/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.options.DatabaseOperationOption;

public class ChangelogOperation {
    private final Connection con;
    private final DatabaseOperationOption option;

    public ChangelogOperation(Connection con, DatabaseOperationOption option) {
        this.con = con;
        this.option = option;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists() {
        try (Statement stmt = this.con.createStatement();){
            boolean bl;
            block14: {
                ResultSet rs = stmt.executeQuery("select count(1) from " + this.option.getChangelogTable());
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public List<Change> selectAll() throws SQLException {
        ArrayList<Change> changes = new ArrayList<Change>();
        try (PreparedStatement stmt = this.con.prepareStatement("select ID, APPLIED_AT, DESCRIPTION from " + this.option.getChangelogTable() + " order by ID");){
            ArrayList<Change> arrayList;
            block13: {
                ResultSet rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        changes.add(new Change(rs.getBigDecimal(1), rs.getString(2), rs.getString(3)));
                    }
                    arrayList = changes;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public void insert(Change change) throws SQLException {
        try (PreparedStatement stmt = this.con.prepareStatement("insert into " + this.option.getChangelogTable() + " (ID, APPLIED_AT, DESCRIPTION) values (?,?,?)");){
            stmt.setBigDecimal(1, change.getId());
            stmt.setString(2, change.getAppliedTimestamp());
            stmt.setString(3, change.getDescription());
            stmt.execute();
            this.con.commit();
        }
    }

    public void deleteById(BigDecimal id) throws SQLException {
        try (PreparedStatement stmt = this.con.prepareStatement("delete from " + this.option.getChangelogTable() + " where ID = ?");){
            stmt.setBigDecimal(1, id);
            stmt.execute();
            this.con.commit();
        }
    }
}

