/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.operations.ChangelogOperation;
import org.apache.ibatis.migration.operations.ScriptRunner;
import org.apache.ibatis.migration.options.DatabaseOperationOption;

public abstract class DatabaseOperation {
    protected void insertChangelog(Change change, Connection con, DatabaseOperationOption option) {
        try {
            ChangelogOperation operation = new ChangelogOperation(con, option);
            change.setAppliedTimestamp(DatabaseOperation.generateAppliedTimeStampAsString());
            operation.insert(change);
        }
        catch (SQLException e) {
            throw new MigrationException("Error querying last applied migration.  Cause: " + e, e);
        }
    }

    protected List<Change> getChangelog(Connection con, DatabaseOperationOption option) {
        try {
            ChangelogOperation operation = new ChangelogOperation(con, option);
            return operation.selectAll();
        }
        catch (SQLException e) {
            throw new MigrationException("Error querying last applied migration.  Cause: " + e, e);
        }
    }

    protected boolean changelogExists(Connection con, DatabaseOperationOption option) {
        ChangelogOperation operation = new ChangelogOperation(con, option);
        return operation.tableExists();
    }

    protected String checkSkippedOrMissing(List<Change> changesInDb, List<Change> migrations) {
        StringBuilder warnings = new StringBuilder();
        String separator = System.lineSeparator();
        int adjust = 0;
        for (int i = 0; i < changesInDb.size(); ++i) {
            Change changeInDb = changesInDb.get(i);
            int migrationIndex = migrations.indexOf(changeInDb);
            if (migrationIndex == -1) {
                warnings.append("WARNING: Missing migration script. id='").append(changeInDb.getId()).append("', description='").append(changeInDb.getDescription()).append("'.").append(separator);
                ++adjust;
                continue;
            }
            if (migrationIndex == i - adjust) continue;
            for (int j = i - adjust; j < migrationIndex; ++j) {
                --adjust;
                warnings.append("WARNING: Migration script '").append(migrations.get(j).getFilename()).append("' was not applied to the database.").append(separator);
            }
        }
        return warnings.toString();
    }

    protected ScriptRunner getScriptRunner(Connection connection, DatabaseOperationOption option, PrintStream printStream) {
        try {
            PrintWriter outWriter = printStream == null ? null : new PrintWriter(printStream);
            ScriptRunner scriptRunner = new ScriptRunner(connection);
            scriptRunner.setLogWriter(outWriter);
            scriptRunner.setErrorLogWriter(outWriter);
            scriptRunner.setStopOnError(option.isStopOnError());
            scriptRunner.setThrowWarning(option.isThrowWarning());
            scriptRunner.setEscapeProcessing(false);
            scriptRunner.setAutoCommit(option.isAutoCommit());
            scriptRunner.setDelimiter(option.getDelimiter());
            scriptRunner.setFullLineDelimiter(option.isFullLineDelimiter());
            scriptRunner.setSendFullScript(option.isSendFullScript());
            scriptRunner.setRemoveCRs(option.isRemoveCRs());
            return scriptRunner;
        }
        catch (Exception e) {
            throw new MigrationException("Error creating ScriptRunner.  Cause: " + e, e);
        }
    }

    public static String generateAppliedTimeStampAsString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()));
    }

    protected void println(PrintStream printStream) {
        if (printStream != null) {
            printStream.println();
        }
    }

    protected void println(PrintStream printStream, String text) {
        if (printStream != null) {
            printStream.println(text);
        }
    }
}

