/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.utils.Util;

public final class StatusOperation
extends DatabaseOperation {
    private int applied;
    private int pending;
    private int missing;
    private List<Change> changes;

    public StatusOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        if (option == null) {
            option = new DatabaseOperationOption();
        }
        this.println(printStream, "ID             Applied At          Description");
        this.println(printStream, Util.horizontalLine("", 80));
        this.changes = new ArrayList<Change>();
        List<Change> migrations = migrationsLoader.getMigrations();
        String skippedOrMissing = null;
        try (Connection con = connectionProvider.getConnection();){
            if (this.changelogExists(con, option)) {
                List<Change> changelog = this.getChangelog(con, option);
                skippedOrMissing = this.checkSkippedOrMissing(changelog, migrations);
                HashSet<Change> changelogAndMigrations = new HashSet<Change>(changelog);
                changelogAndMigrations.addAll(migrations);
                for (Change change : changelogAndMigrations) {
                    if (!migrations.contains(change)) {
                        change = new MissingScript(change);
                        ++this.missing;
                    } else if (change.getAppliedTimestamp() != null) {
                        ++this.applied;
                    } else {
                        ++this.pending;
                    }
                    this.changes.add(change);
                }
            } else {
                this.changes.addAll(migrations);
                this.pending = migrations.size();
            }
        }
        catch (SQLException e) {
            throw new MigrationException("Error getting connection. Cause: " + e, e);
        }
        Collections.sort(this.changes);
        for (Change change : this.changes) {
            this.println(printStream, change.toString());
        }
        this.println(printStream);
        if (skippedOrMissing != null && !skippedOrMissing.isEmpty()) {
            this.println(printStream, skippedOrMissing);
        }
        return this;
    }

    public int getAppliedCount() {
        return this.applied;
    }

    public int getPendingCount() {
        return this.pending;
    }

    public int getMissingCount() {
        return this.missing;
    }

    public List<Change> getCurrentStatus() {
        return this.changes;
    }

    class MissingScript
    extends Change {
        public MissingScript(Change change) {
            super(change);
        }

        @Override
        public String toString() {
            return super.toString() + " <=== MISSING!";
        }
    }
}

