/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.options;

import java.io.File;
import org.apache.ibatis.migration.options.Options;
import org.apache.ibatis.migration.options.SelectedOptions;
import org.apache.ibatis.migration.utils.Util;

public final class OptionsParser
extends Enum<OptionsParser> {
    private static final /* synthetic */ OptionsParser[] $VALUES;

    public static OptionsParser[] values() {
        return (OptionsParser[])$VALUES.clone();
    }

    public static OptionsParser valueOf(String name) {
        return Enum.valueOf(OptionsParser.class, name);
    }

    public static SelectedOptions parse(String[] args) {
        SelectedOptions selectedOptions = new SelectedOptions();
        for (String arg : args) {
            boolean isOption = Util.isOption(arg);
            if (isOption) {
                OptionsParser.parseOptions(arg, selectedOptions);
                continue;
            }
            OptionsParser.setCommandOrAppendParams(arg, selectedOptions);
        }
        return selectedOptions;
    }

    private static void setCommandOrAppendParams(String arg, SelectedOptions options) {
        if (options.getCommand() == null) {
            options.setCommand(arg);
        } else {
            String myParams = options.getParams() == null ? arg : options.getParams() + " " + arg;
            options.setParams(myParams);
        }
    }

    private static boolean parseOptions(String arg, SelectedOptions options) {
        boolean isOption = Util.isOption(arg);
        if (isOption) {
            String[] argParts = arg.substring(2).split("=");
            Options option = Options.valueOf(argParts[0].toUpperCase());
            switch (option) {
                case PATH: {
                    options.getPaths().setBasePath(new File(argParts[1]));
                    break;
                }
                case ENVPATH: {
                    options.getPaths().setEnvPath(new File(argParts[1]));
                    break;
                }
                case SCRIPTPATH: {
                    options.getPaths().setScriptPath(new File(argParts[1]));
                    break;
                }
                case DRIVERPATH: {
                    options.getPaths().setDriverPath(new File(argParts[1]));
                    break;
                }
                case HOOKPATH: {
                    options.getPaths().setHookPath(new File(argParts[1]));
                    break;
                }
                case ENV: {
                    options.setEnvironment(argParts[1]);
                    break;
                }
                case FORCE: {
                    options.setForce(true);
                    break;
                }
                case TRACE: {
                    options.setTrace(true);
                    break;
                }
                case HELP: {
                    options.setHelp(true);
                    break;
                }
                case TEMPLATE: {
                    options.setTemplate(argParts[1]);
                    break;
                }
                case IDPATTERN: {
                    options.setIdPattern(argParts[1]);
                    break;
                }
                case QUIET: {
                    options.setQuiet(true);
                    break;
                }
                case COLOR: {
                    options.setColor(true);
                }
            }
        }
        return isOption;
    }

    private static /* synthetic */ OptionsParser[] $values() {
        return new OptionsParser[0];
    }

    static {
        $VALUES = OptionsParser.$values();
    }
}

