/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisSystemException;
import org.mybatis.spring.SqlSessionCallback;
import org.mybatis.spring.SqlSessionOperations;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSessionTemplate
extends JdbcAccessor
implements SqlSessionOperations {
    private SqlSessionFactory sqlSessionFactory;

    public SqlSessionTemplate() {
    }

    public SqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        this.setSqlSessionFactory(sqlSessionFactory);
        this.afterPropertiesSet();
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        throw new UnsupportedOperationException("Datasource change is not allowed. SqlSessionFactory datasource must be used");
    }

    public DataSource getDataSource() {
        return this.sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sqlSessionFactory, (String)"Property 'sqlSessionFactory' is required");
        super.afterPropertiesSet();
    }

    public <T> T execute(SqlSessionCallback<T> action) throws DataAccessException {
        return this.execute(action, this.sqlSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public <T> T execute(SqlSessionCallback<T> action, ExecutorType executorType) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)this.sqlSessionFactory, (String)"No SqlSessionFactory specified");
        SqlSession sqlSession = SqlSessionUtils.getSqlSession(this.sqlSessionFactory, this.getDataSource(), executorType);
        try {
            T t = action.doInSqlSession(sqlSession);
            return t;
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        finally {
            SqlSessionUtils.closeSqlSession(sqlSession, this.sqlSessionFactory);
        }
    }

    @Override
    public Object selectOne(String statement) {
        return this.selectOne(statement, null);
    }

    @Override
    public Object selectOne(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Object>(){

            @Override
            public Object doInSqlSession(SqlSession sqlSession) {
                return sqlSession.selectOne(statement, parameter);
            }
        });
    }

    @Override
    public <T> List<T> selectList(String statement) {
        return this.selectList(statement, null);
    }

    @Override
    public <T> List<T> selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, RowBounds.DEFAULT);
    }

    @Override
    public <T> List<T> selectList(final String statement, final Object parameter, final RowBounds rowBounds) {
        return (List)this.execute(new SqlSessionCallback<List<T>>(){

            @Override
            public List<T> doInSqlSession(SqlSession sqlSession) {
                return sqlSession.selectList(statement, parameter, rowBounds);
            }
        });
    }

    @Override
    public void select(String statement, Object parameter, ResultHandler handler) {
        this.select(statement, parameter, RowBounds.DEFAULT, handler);
    }

    @Override
    public void select(String statement, ResultHandler handler) {
        this.select(statement, null, RowBounds.DEFAULT, handler);
    }

    @Override
    public void select(final String statement, final Object parameter, final RowBounds rowBounds, final ResultHandler handler) {
        this.execute(new SqlSessionCallback<Object>(){

            @Override
            public Object doInSqlSession(SqlSession sqlSession) {
                sqlSession.select(statement, parameter, rowBounds, handler);
                return null;
            }
        });
    }

    @Override
    public int insert(String statement) {
        return this.insert(statement, null);
    }

    @Override
    public int insert(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.insert(statement, parameter);
            }
        });
    }

    @Override
    public int update(String statement) {
        return this.update(statement, null);
    }

    @Override
    public int update(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.update(statement, parameter);
            }
        });
    }

    @Override
    public int delete(String statement) {
        return this.delete(statement, null);
    }

    @Override
    public int delete(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.delete(statement, parameter);
            }
        });
    }

    @Override
    public <T> T getMapper(final Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                return SqlSessionTemplate.this.execute(new SqlSessionCallback<Object>(){

                    @Override
                    public Object doInSqlSession(SqlSession sqlSession) {
                        try {
                            return method.invoke(sqlSession.getMapper(type), args);
                        }
                        catch (InvocationTargetException e) {
                            throw SqlSessionTemplate.this.wrapException(e.getCause());
                        }
                        catch (Exception e) {
                            throw new MyBatisSystemException("SqlSession operation", e);
                        }
                    }
                });
            }
        });
    }

    protected DataAccessException wrapException(Throwable t) {
        if (t instanceof PersistenceException) {
            if (t.getCause() instanceof SQLException) {
                return this.getExceptionTranslator().translate("SqlSession operation", null, (SQLException)t.getCause());
            }
            return new MyBatisSystemException("SqlSession operation", t);
        }
        if (t instanceof DataAccessException) {
            return (DataAccessException)t;
        }
        return new MyBatisSystemException("SqlSession operation", t);
    }
}

