/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionHolder;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class SqlSessionUtils {
    private static final Log logger = LogFactory.getLog(SqlSessionUtils.class);

    private SqlSessionUtils() {
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        DataSource dataSource = sessionFactory.getConfiguration().getEnvironment().getDataSource();
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, DataSource dataSource) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, ExecutorType executorType) {
        DataSource dataSource = sessionFactory.getConfiguration().getEnvironment().getDataSource();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, DataSource dataSource, ExecutorType executorType) {
        Connection conn;
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder != null && holder.isSynchronizedWithTransaction()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Fetching SqlSession from current transaction");
            }
            if (!holder.getExecutorType().equals((Object)executorType)) {
                throw new TransientDataAccessResourceException("cannot change the ExecutorType when there is an existing transaction");
            }
            holder.requested();
            return holder.getSqlSession();
        }
        boolean transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
        try {
            conn = transactionAware ? dataSource.getConnection() : DataSourceUtils.getConnection((DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection for SqlSession", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating SqlSession from SqlSessionFactory");
        }
        SqlSession session = sessionFactory.openSession(executorType, conn);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (!(sessionFactory.getConfiguration().getEnvironment().getTransactionFactory() instanceof SpringManagedTransactionFactory) && DataSourceUtils.isConnectionTransactional((Connection)conn, (DataSource)dataSource)) {
                throw new TransientDataAccessResourceException("SqlSessionFactory must be using a SpringManagedTransactionFactory in order to use Spring transaction synchronization");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Registering transaction synchronization for SqlSession");
            }
            holder = new SqlSessionHolder(session, executorType);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holder));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SqlSessionSynchronization(holder, sessionFactory));
            holder.setSynchronizedWithTransaction(true);
            holder.requested();
        }
        return session;
    }

    public static void closeSqlSession(SqlSession session, SqlSessionFactory sessionFactory) {
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder == null || session != holder.getSqlSession()) {
            if (session != null) {
                session.close();
            }
        } else {
            holder.released();
        }
    }

    public static boolean isSqlSessionTransactional(SqlSession session, SqlSessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return holder != null && holder.getSqlSession() == session;
    }

    private static final class SqlSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SqlSessionHolder holder;
        private final SqlSessionFactory sessionFactory;

        public SqlSessionSynchronization(SqlSessionHolder holder, SqlSessionFactory sessionFactory) {
            Assert.notNull((Object)((Object)holder), (String)"Parameter 'holder' must be not null");
            Assert.notNull((Object)sessionFactory, (String)"Parameter 'sessionFactory' must be not null");
            this.holder = holder;
            this.sessionFactory = sessionFactory;
        }

        public int getOrder() {
            return 1001;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.holder));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (0 == status) {
                    if (TransactionSynchronizationManager.isActualTransactionActive()) {
                        this.holder.getSqlSession().commit(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Transaction synchronization committed SqlSession");
                        }
                    }
                } else {
                    this.holder.getSqlSession().rollback(false);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Transaction synchronization rolled back SqlSession");
                    }
                }
            }
            finally {
                if (!this.holder.isOpen()) {
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                    this.holder.getSqlSession().close();
                    this.holder.reset();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Transaction synchronization closed SqlSession");
                    }
                }
            }
        }
    }
}

