/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.annotation;

import java.util.Set;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.mybatis.spring.annotation.InternalMapperFactoryBean;
import org.mybatis.spring.annotation.Mapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperScannerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String basePackage;
    private boolean addToConfig = true;
    private String sqlSessionTemplateBeanName;
    private String sqlSessionFactoryBeanName;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateName;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryName;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Set<Class<?>> mapperInterfaces = this.searchForMappers();
        if (mapperInterfaces.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No MyBatis mapper was found in '" + this.basePackage + "' package. Make sure your mappers are annotated with @Mapper");
            }
        } else {
            this.registerMappers(registry, mapperInterfaces);
        }
    }

    private Set<Class<?>> searchForMappers() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Searching for MyBatis mappers in '" + this.basePackage + "' package");
        }
        String[] basePackagesArray = StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n");
        ResolverUtil resolver = new ResolverUtil();
        resolver.findAnnotated(Mapper.class, basePackagesArray);
        return resolver.getClasses();
    }

    private void registerMappers(BeanDefinitionRegistry registry, Set<Class<?>> mapperInterfaces) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering MyBatis mappers");
        }
        for (Class<?> mapperInterface : mapperInterfaces) {
            String name;
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(InternalMapperFactoryBean.class);
            beanDefinitionBuilder.addPropertyValue("mapperInterface", mapperInterface);
            beanDefinitionBuilder.addPropertyValue("addToConfig", (Object)this.addToConfig);
            if (StringUtils.hasLength((String)this.sqlSessionFactoryBeanName)) {
                beanDefinitionBuilder.addPropertyReference("sqlSessionFactory", this.sqlSessionFactoryBeanName);
            }
            if (StringUtils.hasLength((String)this.sqlSessionTemplateBeanName)) {
                beanDefinitionBuilder.addPropertyReference("sqlSessionTemplate", this.sqlSessionTemplateBeanName);
            }
            if (!StringUtils.hasLength((String)(name = mapperInterface.getAnnotation(Mapper.class).value()))) {
                name = mapperInterface.getName();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registering MyBatis mapper with '" + name + "' name and '" + mapperInterface.getName() + "' mapperInterface");
            }
            registry.registerBeanDefinition(name, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
    }
}

