/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.mapper;

import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private Class<T> mapperInterface;
    private boolean addToConfig = true;
    private SqlSession sqlSession;
    private boolean externalSqlSession;

    @Autowired(required=false)
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        if (!this.externalSqlSession) {
            this.sqlSession = new SqlSessionTemplate(sqlSessionFactory);
        }
    }

    @Autowired(required=false)
    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSession = sqlSessionTemplate;
        this.externalSqlSession = true;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sqlSession, (String)"Property 'sqlSessionFactory' or 'sqlSessionTemplate' are required");
        Assert.notNull(this.mapperInterface, (String)"Property 'mapperInterface' is required");
        Configuration configuration = this.sqlSession.getConfiguration();
        if (this.addToConfig && !configuration.hasMapper(this.mapperInterface)) {
            configuration.addMapper(this.mapperInterface);
        }
    }

    public T getObject() throws Exception {
        return (T)this.sqlSession.getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

