/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionHolder;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class SqlSessionUtils {
    private static final Log logger = LogFactory.getLog(SqlSessionUtils.class);

    private SqlSessionUtils() {
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, executorType, null);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        Connection conn;
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        Assert.notNull((Object)executorType, (String)"No ExecutorType specified");
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder != null && holder.isSynchronizedWithTransaction()) {
            if (holder.getExecutorType() != executorType) {
                throw new TransientDataAccessResourceException("Cannot change the ExecutorType when there is an existing transaction");
            }
            holder.requested();
            if (logger.isDebugEnabled()) {
                logger.debug("Fetched SqlSession [" + holder.getSqlSession() + "] from current transaction");
            }
            return holder.getSqlSession();
        }
        DataSource dataSource = sessionFactory.getConfiguration().getEnvironment().getDataSource();
        boolean transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
        try {
            conn = transactionAware ? dataSource.getConnection() : DataSourceUtils.getConnection((DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection for SqlSession", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating SqlSession with JDBC Connection [" + conn + "]");
        }
        SqlSession session = sessionFactory.openSession(executorType, conn);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (!(sessionFactory.getConfiguration().getEnvironment().getTransactionFactory() instanceof SpringManagedTransactionFactory) && DataSourceUtils.isConnectionTransactional((Connection)conn, (DataSource)dataSource)) {
                throw new TransientDataAccessResourceException("SqlSessionFactory must be using a SpringManagedTransactionFactory in order to use Spring transaction synchronization");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Registering transaction synchronization for SqlSession [" + session + "]");
            }
            holder = new SqlSessionHolder(session, executorType, exceptionTranslator);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holder));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SqlSessionSynchronization(holder, sessionFactory));
            holder.setSynchronizedWithTransaction(true);
            holder.requested();
        } else if (logger.isDebugEnabled()) {
            logger.debug("SqlSession [" + session + "] was not registered for synchronization because synchronization is not active");
        }
        return session;
    }

    public static void closeSqlSession(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, (String)"No SqlSession specified");
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder != null && holder.getSqlSession() == session) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing transactional SqlSession [" + session + "]");
            }
            holder.released();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing no transactional SqlSession [" + session + "]");
            }
            session.close();
        }
    }

    public static boolean isSqlSessionTransactional(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, (String)"No SqlSession specified");
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return holder != null && holder.getSqlSession() == session;
    }

    private static final class SqlSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SqlSessionHolder holder;
        private final SqlSessionFactory sessionFactory;

        public SqlSessionSynchronization(SqlSessionHolder holder, SqlSessionFactory sessionFactory) {
            Assert.notNull((Object)((Object)holder), (String)"Parameter 'holder' must be not null");
            Assert.notNull((Object)sessionFactory, (String)"Parameter 'sessionFactory' must be not null");
            this.holder = holder;
            this.sessionFactory = sessionFactory;
        }

        public int getOrder() {
            return 999;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.holder));
        }

        public void beforeCommit(boolean readOnly) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Transaction synchronization committing SqlSession [" + this.holder.getSqlSession() + "]");
                    }
                    this.holder.getSqlSession().commit();
                }
                catch (PersistenceException p) {
                    DataAccessException translated;
                    if (this.holder.getPersistenceExceptionTranslator() != null && (translated = this.holder.getPersistenceExceptionTranslator().translateExceptionIfPossible((RuntimeException)((Object)p))) != null) {
                        throw translated;
                    }
                    throw p;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (!this.holder.isOpen()) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Transaction synchronization closing SqlSession [" + this.holder.getSqlSession() + "]");
                    }
                    this.holder.getSqlSession().close();
                }
                finally {
                    this.holder.reset();
                }
            }
        }
    }
}

