/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.mybatis.scripting.freemarker.FreeMarkerLanguageDriverConfig;
import org.mybatis.scripting.freemarker.FreeMarkerSqlSource;
import org.mybatis.scripting.freemarker.support.TemplateFilePathProvider;

public class FreeMarkerLanguageDriver
implements LanguageDriver {
    protected final FreeMarkerLanguageDriverConfig driverConfig;
    protected final Configuration freemarkerCfg;

    public FreeMarkerLanguageDriver() {
        this(FreeMarkerLanguageDriverConfig.newInstance());
    }

    public FreeMarkerLanguageDriver(FreeMarkerLanguageDriverConfig driverConfig) {
        this.driverConfig = driverConfig;
        this.freemarkerCfg = this.createFreeMarkerConfiguration();
        TemplateFilePathProvider.setLanguageDriverConfig(driverConfig);
    }

    protected Configuration createFreeMarkerConfiguration() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(this.getClass().getClassLoader(), this.driverConfig.getTemplateFile().getBaseDir());
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setNumberFormat("computer");
        cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.driverConfig.getFreemarkerSettings().forEach((name, value) -> {
            try {
                cfg.setSetting(name, value);
            }
            catch (TemplateException e) {
                throw new IllegalStateException(String.format("Fail to configure FreeMarker template setting. name[%s] value[%s]", name, value), e);
            }
        });
        return cfg;
    }

    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        return new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    public SqlSource createSqlSource(org.apache.ibatis.session.Configuration configuration, XNode script, Class<?> parameterType) {
        return this.createSqlSource(configuration, script.getNode().getTextContent());
    }

    public SqlSource createSqlSource(org.apache.ibatis.session.Configuration configuration, String script, Class<?> parameterType) {
        return this.createSqlSource(configuration, script);
    }

    protected SqlSource createSqlSource(Template template, org.apache.ibatis.session.Configuration configuration) {
        return new FreeMarkerSqlSource(template, configuration, this.freemarkerCfg.getIncompatibleImprovements());
    }

    private SqlSource createSqlSource(org.apache.ibatis.session.Configuration configuration, String scriptText) {
        Template template;
        if (scriptText.trim().contains(" ")) {
            try {
                template = new Template(null, (Reader)new StringReader(scriptText), this.freemarkerCfg);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            template = this.freemarkerCfg.getTemplate(scriptText.trim());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.createSqlSource(template, configuration);
    }
}

