/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.freemarker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.text.WordUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class FreeMarkerLanguageDriverConfig {
    private static final String PROPERTY_KEY_CONFIG_FILE = "mybatis-freemarker.config.file";
    private static final String PROPERTY_KEY_CONFIG_ENCODING = "mybatis-freemarker.config.encoding";
    private static final String DEFAULT_PROPERTIES_FILE = "mybatis-freemarker.properties";
    private static final Map<Class<?>, Function<String, Object>> TYPE_CONVERTERS;
    private static final Log log;
    private final Map<String, String> freemarkerSettings = new HashMap<String, String>();
    private final TemplateFileConfig templateFile = new TemplateFileConfig();

    public Map<String, String> getFreemarkerSettings() {
        return this.freemarkerSettings;
    }

    @Deprecated
    public String getBasePackage() {
        return this.templateFile.getBaseDir();
    }

    @Deprecated
    public void setBasePackage(String basePackage) {
        log.warn("The 'basePackage' has been deprecated since 1.2.0. Please use the 'templateFile.baseDir'.");
        this.templateFile.setBaseDir(basePackage);
    }

    public TemplateFileConfig getTemplateFile() {
        return this.templateFile;
    }

    public static FreeMarkerLanguageDriverConfig newInstance() {
        return FreeMarkerLanguageDriverConfig.newInstance(FreeMarkerLanguageDriverConfig.loadDefaultProperties());
    }

    public static FreeMarkerLanguageDriverConfig newInstance(Properties customProperties) {
        FreeMarkerLanguageDriverConfig config = new FreeMarkerLanguageDriverConfig();
        Properties properties = FreeMarkerLanguageDriverConfig.loadDefaultProperties();
        Optional.ofNullable(customProperties).ifPresent(properties::putAll);
        FreeMarkerLanguageDriverConfig.override(config, properties);
        return config;
    }

    public static FreeMarkerLanguageDriverConfig newInstance(Consumer<FreeMarkerLanguageDriverConfig> customizer) {
        FreeMarkerLanguageDriverConfig config = new FreeMarkerLanguageDriverConfig();
        customizer.accept(config);
        FreeMarkerLanguageDriverConfig.override(config, FreeMarkerLanguageDriverConfig.loadDefaultProperties());
        return config;
    }

    private static void override(FreeMarkerLanguageDriverConfig config, Properties properties) {
        MetaObject metaObject = MetaObject.forObject((Object)config, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String propertyPath = WordUtils.uncapitalize((String)WordUtils.capitalize((String)Objects.toString(key), (char[])new char[]{'-'}).replaceAll("-", ""));
            Optional.ofNullable(value).ifPresent(v -> {
                Object convertedValue = TYPE_CONVERTERS.get(metaObject.getSetterType(propertyPath)).apply(value.toString());
                metaObject.setValue(propertyPath, convertedValue);
            });
        }));
    }

    private static Properties loadDefaultProperties() {
        return FreeMarkerLanguageDriverConfig.loadProperties(System.getProperty(PROPERTY_KEY_CONFIG_FILE, DEFAULT_PROPERTIES_FILE));
    }

    private static Properties loadProperties(String resourcePath) {
        InputStream in;
        Properties properties = new Properties();
        try {
            in = Resources.getResourceAsStream((String)resourcePath);
        }
        catch (IOException e) {
            in = null;
        }
        if (in != null) {
            Charset encoding = Optional.ofNullable(System.getProperty(PROPERTY_KEY_CONFIG_ENCODING)).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            try (InputStreamReader inReader = new InputStreamReader(in, encoding);
                 BufferedReader bufReader = new BufferedReader(inReader);){
                properties.load(bufReader);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return properties;
    }

    static {
        HashMap<Class<Object>, Function<String, Object>> converters = new HashMap<Class<Object>, Function<String, Object>>();
        converters.put(String.class, String::trim);
        converters.put(Boolean.TYPE, v -> Boolean.valueOf(v.trim()));
        converters.put(Object.class, v -> v);
        TYPE_CONVERTERS = Collections.unmodifiableMap(converters);
        log = LogFactory.getLog(FreeMarkerLanguageDriverConfig.class);
    }

    public static class TemplateFileConfig {
        private String baseDir = "";
        private final PathProviderConfig pathProvider = new PathProviderConfig();

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public PathProviderConfig getPathProvider() {
            return this.pathProvider;
        }

        public static class PathProviderConfig {
            private String prefix = "";
            private boolean includesPackagePath = true;
            private boolean separateDirectoryPerMapper = true;
            private boolean includesMapperNameWhenSeparateDirectory = true;
            private boolean cacheEnabled = true;

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public boolean isIncludesPackagePath() {
                return this.includesPackagePath;
            }

            public void setIncludesPackagePath(boolean includesPackagePath) {
                this.includesPackagePath = includesPackagePath;
            }

            public boolean isSeparateDirectoryPerMapper() {
                return this.separateDirectoryPerMapper;
            }

            public void setSeparateDirectoryPerMapper(boolean separateDirectoryPerMapper) {
                this.separateDirectoryPerMapper = separateDirectoryPerMapper;
            }

            public boolean isIncludesMapperNameWhenSeparateDirectory() {
                return this.includesMapperNameWhenSeparateDirectory;
            }

            public void setIncludesMapperNameWhenSeparateDirectory(boolean includesMapperNameWhenSeparateDirectory) {
                this.includesMapperNameWhenSeparateDirectory = includesMapperNameWhenSeparateDirectory;
            }

            public boolean isCacheEnabled() {
                return this.cacheEnabled;
            }

            public void setCacheEnabled(boolean cacheEnabled) {
                this.cacheEnabled = cacheEnabled;
            }
        }
    }
}

