/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.freemarker.MyBatisParamDirective;
import org.mybatis.scripting.freemarker.ParamObjectAdapter;

public class FreeMarkerSqlSource
implements SqlSource {
    private final Template template;
    private final Configuration configuration;
    private final Version incompatibleImprovementsVersion;
    private final String databaseId;
    public static final String GENERATED_PARAMS_KEY = "__GENERATED__";

    public FreeMarkerSqlSource(Template template, Configuration configuration, Version incompatibleImprovementsVersion) {
        this.template = template;
        this.configuration = configuration;
        this.incompatibleImprovementsVersion = incompatibleImprovementsVersion;
        this.databaseId = configuration.getDatabaseId();
    }

    protected Object preProcessDataContext(Object dataContext, boolean isMap) {
        if (isMap) {
            ((Map)dataContext).put(MyBatisParamDirective.DEFAULT_KEY, new MyBatisParamDirective());
            ((Map)dataContext).put(MyBatisParamDirective.DATABASE_ID_KEY, new SimpleScalar(this.databaseId));
        } else {
            ((ParamObjectAdapter)dataContext).putAdditionalParam(MyBatisParamDirective.DEFAULT_KEY, (TemplateModel)new MyBatisParamDirective());
            ((ParamObjectAdapter)dataContext).putAdditionalParam(MyBatisParamDirective.DATABASE_ID_KEY, (TemplateModel)new SimpleScalar(this.databaseId));
        }
        return dataContext;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        Object dataContext;
        HashMap map;
        ArrayList generatedParams = new ArrayList();
        if (parameterObject != null) {
            if (parameterObject instanceof Map) {
                map = new HashMap((Map)parameterObject);
                map.put(GENERATED_PARAMS_KEY, generatedParams);
                dataContext = this.preProcessDataContext(map, true);
            } else {
                ParamObjectAdapter adapter = new ParamObjectAdapter(parameterObject, generatedParams, this.incompatibleImprovementsVersion);
                dataContext = this.preProcessDataContext(adapter, false);
            }
        } else {
            map = new HashMap();
            map.put(GENERATED_PARAMS_KEY, generatedParams);
            dataContext = this.preProcessDataContext(map, true);
        }
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.template.process(dataContext, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        String sql = writer.toString();
        if (!generatedParams.isEmpty()) {
            if (!(parameterObject instanceof Map)) {
                throw new UnsupportedOperationException("Auto-generated prepared statements parameters are not available if using parameters object. Use @Param-annotated parameters instead.");
            }
            Map parametersMap = (Map)parameterObject;
            for (int i = 0; i < generatedParams.size(); ++i) {
                parametersMap.put("_p" + i, generatedParams.get(i));
            }
        }
        SqlSourceBuilder sqlSourceParser = new SqlSourceBuilder(this.configuration);
        Class parameterType1 = parameterObject == null ? Object.class : parameterObject.getClass();
        SqlSource sqlSource = sqlSourceParser.parse(sql, parameterType1, new HashMap());
        return sqlSource.getBoundSql(parameterObject);
    }
}

