/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.thymeleaf.context.IContext;
import org.thymeleaf.engine.IterationStatusVar;

public class MyBatisBindingContext {
    static final String CONTEXT_VARIABLE_NAME = "_" + MyBatisBindingContext.class.getName();
    private final Map<String, Object> customBindVariables = new HashMap<String, Object>();
    private final IterationStatusManager iterationStatusManager = new IterationStatusManager();
    private final boolean fallbackParameterObject;

    public static MyBatisBindingContext load(IContext context) {
        return (MyBatisBindingContext)context.getVariable(CONTEXT_VARIABLE_NAME);
    }

    MyBatisBindingContext(boolean fallbackParameterObject) {
        this.fallbackParameterObject = fallbackParameterObject;
    }

    Map<String, Object> getCustomBindVariables() {
        return this.customBindVariables;
    }

    public void setCustomBindVariable(String name, Object value) {
        this.customBindVariables.put(name, value);
    }

    public boolean containsCustomBindVariable(String name) {
        return this.customBindVariables.containsKey(name);
    }

    public String generateUniqueName(String objectName, IterationStatusVar status) {
        return this.iterationStatusManager.generateUniqueName(objectName, status);
    }

    boolean isFallbackParameterObject() {
        return this.fallbackParameterObject;
    }

    private static class IterationStatusManager {
        private final Map<String, List<IterationStatusVar>> statusListMapping = new HashMap<String, List<IterationStatusVar>>();

        private IterationStatusManager() {
        }

        private String generateUniqueName(String objectName, IterationStatusVar status) {
            int index;
            List statusList = this.statusListMapping.computeIfAbsent(objectName, k -> new ArrayList());
            if (!statusList.contains(status)) {
                index = statusList.size();
                statusList.add(status);
            } else {
                index = statusList.indexOf(status);
            }
            return objectName + "_" + index + "_" + status.getIndex();
        }
    }
}

