/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.thymeleaf.MyBatisDialect;
import org.mybatis.scripting.thymeleaf.MyBatisIntegratingEngineContextFactory;
import org.mybatis.scripting.thymeleaf.TemplateEngineCustomizer;
import org.mybatis.scripting.thymeleaf.ThymeleafLanguageDriverConfig;
import org.mybatis.scripting.thymeleaf.ThymeleafSqlSource;
import org.mybatis.scripting.thymeleaf.expression.Likes;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafLanguageDriver
implements LanguageDriver {
    private final ITemplateEngine templateEngine;

    public ThymeleafLanguageDriver() {
        this.templateEngine = this.createDefaultTemplateEngine(ThymeleafLanguageDriverConfig.newInstance());
    }

    public ThymeleafLanguageDriver(ThymeleafLanguageDriverConfig config) {
        this.templateEngine = this.createDefaultTemplateEngine(config);
    }

    public ThymeleafLanguageDriver(ITemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    private ITemplateEngine createDefaultTemplateEngine(ThymeleafLanguageDriverConfig config) {
        MyBatisDialect dialect = new MyBatisDialect(config.getDialect().getPrefix());
        Likes likes = Likes.newBuilder().escapeChar(config.getDialect().getLikeEscapeChar()).escapeClauseFormat(config.getDialect().getLikeEscapeClauseFormat()).additionalEscapeTargetChars(config.getDialect().getLikeAdditionalEscapeTargetChars()).build();
        dialect.setLikes(likes);
        ClassLoaderTemplateResolver classLoaderTemplateResolver = new ClassLoaderTemplateResolver();
        TemplateMode mode = config.isUse2way() ? TemplateMode.CSS : TemplateMode.TEXT;
        classLoaderTemplateResolver.setOrder(Integer.valueOf(1));
        classLoaderTemplateResolver.setTemplateMode(mode);
        classLoaderTemplateResolver.setResolvablePatterns(Arrays.stream(config.getTemplateFile().getPatterns()).collect(Collectors.toSet()));
        classLoaderTemplateResolver.setCharacterEncoding(config.getTemplateFile().getEncoding().name());
        classLoaderTemplateResolver.setCacheable(config.getTemplateFile().isCacheEnabled());
        classLoaderTemplateResolver.setCacheTTLMs(config.getTemplateFile().getCacheTtl());
        classLoaderTemplateResolver.setPrefix(config.getTemplateFile().getBaseDir());
        StringTemplateResolver stringTemplateResolver = new StringTemplateResolver();
        stringTemplateResolver.setOrder(Integer.valueOf(2));
        stringTemplateResolver.setTemplateMode(mode);
        TemplateEngine targetTemplateEngine = new TemplateEngine();
        targetTemplateEngine.addTemplateResolver((ITemplateResolver)classLoaderTemplateResolver);
        targetTemplateEngine.addTemplateResolver((ITemplateResolver)stringTemplateResolver);
        targetTemplateEngine.addDialect((IDialect)dialect);
        targetTemplateEngine.setEngineContextFactory((IEngineContextFactory)new MyBatisIntegratingEngineContextFactory(targetTemplateEngine.getEngineContextFactory()));
        TemplateEngineCustomizer customizer = Optional.ofNullable(config.getCustomizer()).map(v -> {
            try {
                return (TemplateEngineCustomizer)v.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot create an instance for class: " + v, e);
            }
        }).map(TemplateEngineCustomizer.class::cast).orElse(TemplateEngineCustomizer.BuiltIn.DO_NOTHING);
        customizer.accept(targetTemplateEngine);
        return targetTemplateEngine;
    }

    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        return new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        return this.createSqlSource(configuration, script.getNode().getTextContent(), parameterType);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        return new ThymeleafSqlSource(configuration, this.templateEngine, script.trim(), parameterType);
    }
}

