/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.mybatis.scripting.thymeleaf.TemplateEngineCustomizer;
import org.thymeleaf.util.StringUtils;

public class ThymeleafLanguageDriverConfig {
    private static final String PROPERTY_KEY_CONFIG_FILE = "mybatis-thymeleaf.config.file";
    private static final String PROPERTY_KEY_CONFIG_ENCODING = "mybatis-thymeleaf.config.encoding";
    private static final String DEFAULT_PROPERTIES_FILE = "mybatis-thymeleaf.properties";
    private static final Map<Class<?>, Function<String, Object>> TYPE_CONVERTERS;
    private boolean use2way = true;
    private Class<? extends TemplateEngineCustomizer> customizer;
    private final TemplateFileConfig templateFile = new TemplateFileConfig();
    private final DialectConfig dialect = new DialectConfig();

    public boolean isUse2way() {
        return this.use2way;
    }

    public void setUse2way(boolean use2way) {
        this.use2way = use2way;
    }

    public Class<? extends TemplateEngineCustomizer> getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(Class<? extends TemplateEngineCustomizer> customizer) {
        this.customizer = customizer;
    }

    public TemplateFileConfig getTemplateFile() {
        return this.templateFile;
    }

    public DialectConfig getDialect() {
        return this.dialect;
    }

    public static ThymeleafLanguageDriverConfig newInstance() {
        return ThymeleafLanguageDriverConfig.newInstance(ThymeleafLanguageDriverConfig.loadDefaultProperties());
    }

    public static ThymeleafLanguageDriverConfig newInstance(String resourcePath) {
        Properties properties = ThymeleafLanguageDriverConfig.loadDefaultProperties();
        properties.putAll((Map<?, ?>)ThymeleafLanguageDriverConfig.loadProperties(resourcePath));
        return ThymeleafLanguageDriverConfig.newInstance(properties);
    }

    public static ThymeleafLanguageDriverConfig newInstance(Properties customProperties) {
        ThymeleafLanguageDriverConfig config = new ThymeleafLanguageDriverConfig();
        Properties properties = ThymeleafLanguageDriverConfig.loadDefaultProperties();
        Optional.ofNullable(customProperties).ifPresent(properties::putAll);
        ThymeleafLanguageDriverConfig.override(config, properties);
        return config;
    }

    public static ThymeleafLanguageDriverConfig newInstance(Consumer<ThymeleafLanguageDriverConfig> customizer) {
        ThymeleafLanguageDriverConfig config = new ThymeleafLanguageDriverConfig();
        customizer.accept(config);
        ThymeleafLanguageDriverConfig.override(config, ThymeleafLanguageDriverConfig.loadDefaultProperties());
        return config;
    }

    private static void override(ThymeleafLanguageDriverConfig config, Properties properties) {
        MetaObject metaObject = MetaObject.forObject((Object)config, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String propertyPath = StringUtils.unCapitalize((Object)StringUtils.capitalizeWords((Object)key, (Object)"-").replaceAll("-", ""));
            Optional.ofNullable(value).ifPresent(v -> {
                Object convertedValue = TYPE_CONVERTERS.get(metaObject.getSetterType(propertyPath)).apply(value.toString());
                metaObject.setValue(propertyPath, convertedValue);
            });
        }));
    }

    private static Properties loadDefaultProperties() {
        return ThymeleafLanguageDriverConfig.loadProperties(System.getProperty(PROPERTY_KEY_CONFIG_FILE, DEFAULT_PROPERTIES_FILE));
    }

    private static Properties loadProperties(String resourcePath) {
        InputStream in;
        Properties properties = new Properties();
        try {
            in = Resources.getResourceAsStream((String)resourcePath);
        }
        catch (IOException e) {
            in = null;
        }
        if (in != null) {
            Charset encoding = Optional.ofNullable(System.getProperty(PROPERTY_KEY_CONFIG_ENCODING)).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            try (InputStreamReader inReader = new InputStreamReader(in, encoding);
                 BufferedReader bufReader = new BufferedReader(inReader);){
                properties.load(bufReader);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return properties;
    }

    private static Class<?> classForName(String value) {
        try {
            return Resources.classForName((String)value.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        HashMap<Class<Object>, Function<String, Object>> converters = new HashMap<Class<Object>, Function<String, Object>>();
        converters.put(Boolean.TYPE, v -> Boolean.valueOf(v.trim()));
        converters.put(String.class, String::trim);
        converters.put(Character[].class, v -> Stream.of(v.split(",")).map(String::trim).filter(e -> e.length() == 1).map(e -> Character.valueOf(e.charAt(0))).toArray(Character[]::new));
        converters.put(Character.class, v -> Character.valueOf(v.trim().charAt(0)));
        converters.put(Charset.class, v -> Charset.forName(v.trim()));
        converters.put(Long.class, v -> Long.valueOf(v.trim()));
        converters.put(String[].class, v -> Stream.of(v.split(",")).map(String::trim).toArray(String[]::new));
        converters.put(Class.class, ThymeleafLanguageDriverConfig::classForName);
        TYPE_CONVERTERS = Collections.unmodifiableMap(converters);
    }

    public static class DialectConfig {
        private String prefix = "mb";
        private Character likeEscapeChar = Character.valueOf('\\');
        private String likeEscapeClauseFormat = "ESCAPE '%s'";
        private Character[] likeAdditionalEscapeTargetChars;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Character getLikeEscapeChar() {
            return this.likeEscapeChar;
        }

        public void setLikeEscapeChar(Character likeEscapeChar) {
            this.likeEscapeChar = likeEscapeChar;
        }

        public String getLikeEscapeClauseFormat() {
            return this.likeEscapeClauseFormat;
        }

        public void setLikeEscapeClauseFormat(String likeEscapeClauseFormat) {
            this.likeEscapeClauseFormat = likeEscapeClauseFormat;
        }

        public Character[] getLikeAdditionalEscapeTargetChars() {
            return this.likeAdditionalEscapeTargetChars;
        }

        public void setLikeAdditionalEscapeTargetChars(Character ... likeAdditionalEscapeTargetChars) {
            this.likeAdditionalEscapeTargetChars = likeAdditionalEscapeTargetChars;
        }
    }

    public static class TemplateFileConfig {
        private Charset encoding = StandardCharsets.UTF_8;
        private String baseDir = "";
        private String[] patterns = new String[]{"*.sql"};
        private boolean cacheEnabled = true;
        private Long cacheTtl;
        private final PathProviderConfig pathProvider = new PathProviderConfig();

        public Charset getEncoding() {
            return this.encoding;
        }

        public void setEncoding(Charset encoding) {
            this.encoding = encoding;
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public void setPatterns(String ... patterns) {
            this.patterns = patterns;
        }

        public boolean isCacheEnabled() {
            return this.cacheEnabled;
        }

        public void setCacheEnabled(boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
        }

        public Long getCacheTtl() {
            return this.cacheTtl;
        }

        public void setCacheTtl(Long cacheTtl) {
            this.cacheTtl = cacheTtl;
        }

        public PathProviderConfig getPathProvider() {
            return this.pathProvider;
        }

        public static class PathProviderConfig {
            private String prefix = "";
            private boolean includesPackagePath = true;
            private boolean separateDirectoryPerMapper = true;
            private boolean includesMapperNameWhenSeparateDirectory = true;
            private boolean cacheEnabled = true;

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public boolean isIncludesPackagePath() {
                return this.includesPackagePath;
            }

            public void setIncludesPackagePath(boolean includesPackagePath) {
                this.includesPackagePath = includesPackagePath;
            }

            public boolean isSeparateDirectoryPerMapper() {
                return this.separateDirectoryPerMapper;
            }

            public void setSeparateDirectoryPerMapper(boolean separateDirectoryPerMapper) {
                this.separateDirectoryPerMapper = separateDirectoryPerMapper;
            }

            public boolean isIncludesMapperNameWhenSeparateDirectory() {
                return this.includesMapperNameWhenSeparateDirectory;
            }

            public void setIncludesMapperNameWhenSeparateDirectory(boolean includesMapperNameWhenSeparateDirectory) {
                this.includesMapperNameWhenSeparateDirectory = includesMapperNameWhenSeparateDirectory;
            }

            public boolean isCacheEnabled() {
                return this.cacheEnabled;
            }

            public void setCacheEnabled(boolean cacheEnabled) {
                this.cacheEnabled = cacheEnabled;
            }
        }
    }
}

