/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.thymeleaf.MyBatisBindingContext;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.context.IContext;

class ThymeleafSqlSource
implements SqlSource {
    private final Configuration configuration;
    private final ITemplateEngine templateEngine;
    private final SqlSourceBuilder sqlSourceBuilder;
    private final String sqlTemplate;
    private final Class<?> parameterType;

    ThymeleafSqlSource(Configuration configuration, ITemplateEngine templateEngine, String sqlTemplate, Class<?> parameterType) {
        this.configuration = configuration;
        this.templateEngine = templateEngine;
        this.sqlTemplate = sqlTemplate;
        this.parameterType = parameterType;
        this.sqlSourceBuilder = new SqlSourceBuilder(configuration);
    }

    public BoundSql getBoundSql(Object parameterObject) {
        AbstractContext context;
        Class<Object> processingParameterType = this.parameterType == null ? (parameterObject == null ? Object.class : parameterObject.getClass()) : this.parameterType;
        MyBatisBindingContext bindingContext = new MyBatisBindingContext(parameterObject != null && this.configuration.getTypeHandlerRegistry().hasTypeHandler(processingParameterType));
        DynamicContext dynamicContext = new DynamicContext(this.configuration, parameterObject);
        dynamicContext.bind(MyBatisBindingContext.CONTEXT_VARIABLE_NAME, (Object)bindingContext);
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            context = new MapBasedContext(parameterMap, dynamicContext, this.configuration.getVariables());
        } else {
            MetaClass metaClass = MetaClass.forClass(processingParameterType, (ReflectorFactory)this.configuration.getReflectorFactory());
            context = new MetaClassBasedContext(parameterObject, metaClass, processingParameterType, dynamicContext, this.configuration.getVariables());
        }
        String sql = this.templateEngine.process(this.sqlTemplate, (IContext)context);
        bindingContext.getCustomBindVariables().forEach((arg_0, arg_1) -> ((DynamicContext)dynamicContext).bind(arg_0, arg_1));
        SqlSource sqlSource = this.sqlSourceBuilder.parse(sql, processingParameterType, dynamicContext.getBindings());
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        dynamicContext.getBindings().forEach((arg_0, arg_1) -> ((BoundSql)boundSql).setAdditionalParameter(arg_0, arg_1));
        return boundSql;
    }

    private static class MetaClassBasedContext
    extends AbstractContext {
        private final Object parameterObject;
        private final MetaClass parameterMetaClass;
        private final Class<?> parameterType;

        private MetaClassBasedContext(Object parameterObject, MetaClass parameterMetaClass, Class<?> parameterType, DynamicContext dynamicContext, Properties configurationProperties) {
            super(dynamicContext, configurationProperties);
            this.parameterObject = parameterObject;
            this.parameterMetaClass = parameterMetaClass;
            this.parameterType = parameterType;
            this.addVariableNames(Arrays.asList(parameterMetaClass.getGetterNames()));
        }

        @Override
        public Object getParameterValue(String name) {
            try {
                return this.parameterMetaClass.getGetInvoker(name).invoke(this.parameterObject, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Cannot get a value for property named '%s' in '%s'", name, this.parameterType), e);
            }
        }
    }

    private static class MapBasedContext
    extends AbstractContext {
        private final Map<String, Object> variables;

        private MapBasedContext(Map<String, Object> parameterMap, DynamicContext dynamicContext, Properties configurationProperties) {
            super(dynamicContext, configurationProperties);
            this.variables = parameterMap;
            this.addVariableNames(parameterMap.keySet());
        }

        @Override
        public Object getParameterValue(String name) {
            return this.variables.get(name);
        }
    }

    private static abstract class AbstractContext
    implements IContext {
        private final DynamicContext dynamicContext;
        private final Properties configurationProperties;
        private final Set<String> variableNames;

        private AbstractContext(DynamicContext dynamicContext, Properties configurationProperties) {
            this.dynamicContext = dynamicContext;
            this.configurationProperties = configurationProperties;
            this.variableNames = new HashSet<String>();
            this.addVariableNames(dynamicContext.getBindings().keySet());
            Optional.ofNullable(configurationProperties).ifPresent(v -> this.addVariableNames(v.stringPropertyNames()));
        }

        void addVariableNames(Collection<String> names) {
            this.variableNames.addAll(names);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public boolean containsVariable(String name) {
            return this.variableNames.contains(name);
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        public Object getVariable(String name) {
            if (this.dynamicContext.getBindings().containsKey(name)) {
                return this.dynamicContext.getBindings().get(name);
            }
            if (this.configurationProperties != null && this.configurationProperties.containsKey(name)) {
                return this.configurationProperties.getProperty(name);
            }
            return this.getParameterValue(name);
        }

        abstract Object getParameterValue(String var1);
    }
}

