/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf.processor;

import java.util.List;
import java.util.Objects;
import org.mybatis.scripting.thymeleaf.MyBatisBindingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;

public class MyBatisBindTagProcessor
extends AbstractAttributeTagProcessor {
    private static final int PRECEDENCE = 600;
    private static final String ATTR_NAME = "bind";

    public MyBatisBindTagProcessor(TemplateMode templateMode, String prefix) {
        super(templateMode, prefix, null, false, ATTR_NAME, true, 600, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        AssignationSequence assignations = AssignationUtils.parseAssignationSequence((IExpressionContext)context, (String)attributeValue, (boolean)false);
        List assignationValues = assignations.getAssignations();
        assignationValues.forEach(assignation -> {
            IStandardExpression nameExp = assignation.getLeft();
            Object name = nameExp.execute((IExpressionContext)context);
            IStandardExpression valueExp = assignation.getRight();
            Object value = valueExp.execute((IExpressionContext)context);
            if (Objects.isNull(name) || StringUtils.isEmpty((String)name.toString())) {
                throw new TemplateProcessingException("Variable name expression evaluated as null or empty: \"" + nameExp + "\"");
            }
            MyBatisBindingContext bindingContext = MyBatisBindingContext.load((IContext)context);
            bindingContext.setCustomBindVariable(name.toString(), value);
        });
    }
}

