/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface PropertyAccessor {
    public Set<String> getPropertyNames(Class<?> var1);

    public Class<?> getPropertyType(Class<?> var1, String var2);

    public Object getPropertyValue(Object var1, String var2);

    public void setPropertyValue(Object var1, String var2, Object var3);

    public static enum BuiltIn implements PropertyAccessor
    {
        STANDARD(new StandardPropertyAccessor());

        private final PropertyAccessor delegate;

        private BuiltIn(PropertyAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<String> getPropertyNames(Class<?> type) {
            return this.delegate.getPropertyNames(type);
        }

        @Override
        public Class<?> getPropertyType(Class<?> type, String name) {
            return this.delegate.getPropertyType(type, name);
        }

        @Override
        public Object getPropertyValue(Object target, String name) {
            return this.delegate.getPropertyValue(target, name);
        }

        @Override
        public void setPropertyValue(Object target, String name, Object value) {
            this.delegate.setPropertyValue(target, name, value);
        }

        static class StandardPropertyAccessor
        implements PropertyAccessor {
            private static Map<Class<?>, Map<String, PropertyDescriptor>> cache = new ConcurrentHashMap();

            StandardPropertyAccessor() {
            }

            @Override
            public Set<String> getPropertyNames(Class<?> type) {
                return StandardPropertyAccessor.getPropertyDescriptors(type).keySet();
            }

            @Override
            public Class<?> getPropertyType(Class<?> type, String name) {
                return Optional.ofNullable(StandardPropertyAccessor.getPropertyDescriptors(type).get(name)).orElseThrow(() -> new IllegalArgumentException(String.format("Does not get a property type because property '%s' not found on '%s' class.", name, type.getName()))).getPropertyType();
            }

            @Override
            public Object getPropertyValue(Object target, String name) {
                try {
                    return Optional.ofNullable(StandardPropertyAccessor.getPropertyDescriptors(target.getClass()).get(name)).map(PropertyDescriptor::getReadMethod).orElseThrow(() -> new IllegalArgumentException(String.format("Does not get a property value because property '%s' not found on '%s' class.", name, target.getClass().getName()))).invoke(target, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void setPropertyValue(Object target, String name, Object value) {
                try {
                    Optional.ofNullable(StandardPropertyAccessor.getPropertyDescriptors(target.getClass()).get(name)).map(PropertyDescriptor::getWriteMethod).orElseThrow(() -> new IllegalArgumentException(String.format("Does not set a property value because property '%s' not found on '%s' class.", name, target.getClass().getName()))).invoke(target, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            static void clearCache() {
                cache.clear();
            }

            private static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> type) {
                return cache.computeIfAbsent(type, key -> {
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(type);
                        Map<String, PropertyDescriptor> map = Stream.of(beanInfo.getPropertyDescriptors()).filter(x -> !x.getName().equals("class")).collect(Collectors.toMap(FeatureDescriptor::getName, v -> v));
                        return map;
                    }
                    catch (IntrospectionException e) {
                        throw new IllegalStateException(e);
                    }
                    finally {
                        Introspector.flushFromCaches(type);
                    }
                });
            }
        }
    }
}

