/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mybatis.scripting.thymeleaf.MyBatisBindingContext;
import org.mybatis.scripting.thymeleaf.MyBatisDialect;
import org.mybatis.scripting.thymeleaf.MyBatisIntegratingEngineContextFactory;
import org.mybatis.scripting.thymeleaf.PropertyAccessor;
import org.mybatis.scripting.thymeleaf.SqlGeneratorConfig;
import org.mybatis.scripting.thymeleaf.expression.Likes;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class SqlGenerator {
    private final ITemplateEngine templateEngine;
    private Map<String, Object> defaultCustomVariables = Collections.emptyMap();
    private PropertyAccessor propertyAccessor = PropertyAccessor.BuiltIn.STANDARD;
    private BiFunction<Object, Map<String, Object>, IContext> contextFactory = (x$0, x$1) -> new DefaultContext(x$0, (Map<String, Object>)x$1);

    public SqlGenerator() {
        this.templateEngine = this.createDefaultTemplateEngine(SqlGeneratorConfig.newInstance());
    }

    public SqlGenerator(SqlGeneratorConfig config) {
        this.templateEngine = this.createDefaultTemplateEngine(config);
    }

    public SqlGenerator(ITemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setDefaultCustomVariables(Map<String, Object> defaultCustomVariables) {
        this.defaultCustomVariables = Optional.ofNullable(defaultCustomVariables).map(Collections::unmodifiableMap).orElseGet(Collections::emptyMap);
    }

    public Map<String, Object> getDefaultCustomVariables() {
        return this.defaultCustomVariables;
    }

    public void setPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.propertyAccessor = Optional.ofNullable(propertyAccessor).orElse(PropertyAccessor.BuiltIn.STANDARD);
    }

    void setContextFactory(BiFunction<Object, Map<String, Object>, IContext> contextFactory) {
        this.contextFactory = contextFactory;
    }

    private ITemplateEngine createDefaultTemplateEngine(SqlGeneratorConfig config) {
        MyBatisDialect dialect = new MyBatisDialect(config.getDialect().getPrefix());
        Optional.ofNullable(config.getDialect().getBindVariableRenderInstance()).ifPresent(dialect::setBindVariableRender);
        Likes likes = Likes.newBuilder().escapeChar(config.getDialect().getLikeEscapeChar()).escapeClauseFormat(config.getDialect().getLikeEscapeClauseFormat()).additionalEscapeTargetChars(config.getDialect().getLikeAdditionalEscapeTargetChars()).build();
        dialect.setLikes(likes);
        ClassLoaderTemplateResolver classLoaderTemplateResolver = new ClassLoaderTemplateResolver();
        TemplateMode mode = config.isUse2way() ? TemplateMode.CSS : TemplateMode.TEXT;
        classLoaderTemplateResolver.setOrder(Integer.valueOf(1));
        classLoaderTemplateResolver.setTemplateMode(mode);
        classLoaderTemplateResolver.setResolvablePatterns(Arrays.stream(config.getTemplateFile().getPatterns()).collect(Collectors.toSet()));
        classLoaderTemplateResolver.setCharacterEncoding(config.getTemplateFile().getEncoding().name());
        classLoaderTemplateResolver.setCacheable(config.getTemplateFile().isCacheEnabled());
        classLoaderTemplateResolver.setCacheTTLMs(config.getTemplateFile().getCacheTtl());
        classLoaderTemplateResolver.setPrefix(config.getTemplateFile().getBaseDir());
        StringTemplateResolver stringTemplateResolver = new StringTemplateResolver();
        stringTemplateResolver.setOrder(Integer.valueOf(2));
        stringTemplateResolver.setTemplateMode(mode);
        TemplateEngine targetTemplateEngine = new TemplateEngine();
        targetTemplateEngine.addTemplateResolver((ITemplateResolver)classLoaderTemplateResolver);
        targetTemplateEngine.addTemplateResolver((ITemplateResolver)stringTemplateResolver);
        targetTemplateEngine.addDialect((IDialect)dialect);
        targetTemplateEngine.setEngineContextFactory((IEngineContextFactory)new MyBatisIntegratingEngineContextFactory(targetTemplateEngine.getEngineContextFactory()));
        Optional.ofNullable(config.getCustomizerInstance()).ifPresent(x -> x.accept(targetTemplateEngine));
        return targetTemplateEngine;
    }

    public String generate(CharSequence sqlTemplate, Object parameter) {
        return this.generate(sqlTemplate, parameter, null, null);
    }

    public String generate(CharSequence sqlTemplate, Object parameter, BiConsumer<String, Object> customBindVariableBinder) {
        return this.generate(sqlTemplate, parameter, customBindVariableBinder, null);
    }

    public String generate(CharSequence sqlTemplate, Object parameter, Map<String, Object> customVariables) {
        return this.generate(sqlTemplate, parameter, null, customVariables);
    }

    public String generate(CharSequence sqlTemplate, Object parameter, BiConsumer<String, Object> customBindVariableBinder, Map<String, Object> customVariables) {
        HashMap<String, Object> processingCustomVariables = new HashMap<String, Object>(this.defaultCustomVariables);
        Optional.ofNullable(customVariables).ifPresent(processingCustomVariables::putAll);
        IContext context = this.contextFactory.apply(parameter, processingCustomVariables);
        String sql = this.templateEngine.process(sqlTemplate.toString(), context);
        MyBatisBindingContext bindingContext = MyBatisBindingContext.load(context);
        if (bindingContext != null && customBindVariableBinder != null) {
            bindingContext.getCustomBindVariables().forEach(customBindVariableBinder);
        }
        return sql;
    }

    private class DefaultContext
    implements IContext {
        private final Object parameter;
        private final Map<String, Object> mapParameter;
        private final Set<String> propertyNames = new HashSet<String>();
        private final Map<String, Object> customVariables;

        private DefaultContext(Object parameter, Map<String, Object> customVariables) {
            boolean fallback;
            this.parameter = parameter;
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                this.propertyNames.addAll(map.keySet());
                this.mapParameter = map;
                fallback = false;
            } else {
                this.mapParameter = null;
                if (parameter != null) {
                    this.propertyNames.addAll(SqlGenerator.this.propertyAccessor.getPropertyNames(parameter.getClass()));
                }
                fallback = this.propertyNames.isEmpty();
            }
            MyBatisBindingContext bindingContext = new MyBatisBindingContext(fallback);
            this.customVariables = customVariables;
            customVariables.put(MyBatisBindingContext.CONTEXT_VARIABLE_NAME, bindingContext);
            customVariables.put("_parameter", parameter);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public boolean containsVariable(String name) {
            return this.customVariables.containsKey(name) || this.propertyNames.contains(name);
        }

        public Set<String> getVariableNames() {
            HashSet<String> variableNames = new HashSet<String>(this.customVariables.keySet());
            variableNames.addAll(this.propertyNames);
            return variableNames;
        }

        public Object getVariable(String name) {
            if (this.customVariables.containsKey(name)) {
                return this.customVariables.get(name);
            }
            if (this.mapParameter == null) {
                return SqlGenerator.this.propertyAccessor.getPropertyValue(this.parameter, name);
            }
            return this.mapParameter.get(name);
        }
    }

    static class ContextKeys {
        static final String PARAMETER_OBJECT = "_parameter";

        ContextKeys() {
        }
    }
}

