/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.scripting.thymeleaf.PropertyAccessor;
import org.mybatis.scripting.thymeleaf.TemplateEngineCustomizer;
import org.mybatis.scripting.thymeleaf.processor.BindVariableRender;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.StringUtils;

public class SqlGeneratorConfig {
    private static final Map<Class<?>, Function<String, Object>> TYPE_CONVERTERS;
    private boolean use2way = true;
    private TemplateEngineCustomizer customizer;
    private final TemplateFileConfig templateFile = new TemplateFileConfig();
    private final DialectConfig dialect = new DialectConfig();

    public boolean isUse2way() {
        return this.use2way;
    }

    public void setUse2way(boolean use2way) {
        this.use2way = use2way;
    }

    @Deprecated
    public Class<? extends TemplateEngineCustomizer> getCustomizer() {
        return this.customizer == null ? null : this.customizer.getClass();
    }

    @Deprecated
    public void setCustomizer(Class<? extends TemplateEngineCustomizer> customizer) {
        this.customizer = SqlGeneratorConfig.newInstanceForType(customizer);
    }

    public TemplateEngineCustomizer getCustomizerInstance() {
        return this.customizer;
    }

    public void setCustomizerInstance(TemplateEngineCustomizer customizer) {
        this.customizer = customizer;
    }

    public TemplateFileConfig getTemplateFile() {
        return this.templateFile;
    }

    public DialectConfig getDialect() {
        return this.dialect;
    }

    public static SqlGeneratorConfig newInstance() {
        SqlGeneratorConfig config = new SqlGeneratorConfig();
        SqlGeneratorConfig.applyDefaultProperties(config);
        return config;
    }

    public static SqlGeneratorConfig newInstanceWithResourcePath(String resourcePath) {
        SqlGeneratorConfig config = new SqlGeneratorConfig();
        SqlGeneratorConfig.applyResourcePath(config, resourcePath);
        return config;
    }

    public static SqlGeneratorConfig newInstanceWithProperties(Properties customProperties) {
        SqlGeneratorConfig config = new SqlGeneratorConfig();
        SqlGeneratorConfig.applyProperties(config, customProperties);
        return config;
    }

    public static SqlGeneratorConfig newInstanceWithCustomizer(Consumer<SqlGeneratorConfig> customizer) {
        SqlGeneratorConfig config = new SqlGeneratorConfig();
        customizer.accept(config);
        SqlGeneratorConfig.applyDefaultProperties(config);
        return config;
    }

    static <T extends SqlGeneratorConfig> void applyDefaultProperties(T config) {
        SqlGeneratorConfig.applyProperties(config, SqlGeneratorConfig.loadDefaultProperties());
    }

    static <T extends SqlGeneratorConfig> void applyResourcePath(T config, String resourcePath) {
        Properties properties = SqlGeneratorConfig.loadDefaultProperties();
        properties.putAll((Map<?, ?>)SqlGeneratorConfig.loadProperties(resourcePath));
        SqlGeneratorConfig.applyProperties(config, properties);
    }

    static <T extends SqlGeneratorConfig> void applyProperties(T config, Properties customProperties) {
        Properties properties = SqlGeneratorConfig.loadDefaultProperties();
        Optional.ofNullable(customProperties).ifPresent(properties::putAll);
        SqlGeneratorConfig.override(config, properties);
    }

    static <T> T newInstanceForType(Class<T> type) {
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot create an instance for class: " + String.valueOf(type), e);
        }
    }

    private static void override(SqlGeneratorConfig config, Properties properties) {
        PropertyAccessor.BuiltIn standardPropertyAccessor = PropertyAccessor.BuiltIn.STANDARD;
        try {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String propertyPath = StringUtils.unCapitalize((Object)StringUtils.capitalizeWords((Object)key, (Object)"-").replaceAll("-", ""));
                try {
                    String propertyName;
                    Object target = config;
                    if (propertyPath.indexOf(46) != -1) {
                        String[] propertyPaths = StringUtils.split((Object)propertyPath, (String)".");
                        propertyName = propertyPaths[propertyPaths.length - 1];
                        for (String path : Arrays.copyOf(propertyPaths, propertyPaths.length - 1)) {
                            target = standardPropertyAccessor.getPropertyValue(target, path);
                        }
                    } else {
                        propertyName = propertyPath;
                    }
                    Object convertedValue = TYPE_CONVERTERS.getOrDefault(standardPropertyAccessor.getPropertyType(target.getClass(), propertyName), v -> v).apply(value.toString());
                    standardPropertyAccessor.setPropertyValue(target, propertyName, convertedValue);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Detected an invalid property. key='%s' value='%s'", key, value), e);
                }
            }));
        }
        finally {
            PropertyAccessor.BuiltIn.StandardPropertyAccessor.clearCache();
        }
    }

    private static Properties loadDefaultProperties() {
        return SqlGeneratorConfig.loadProperties(System.getProperty("mybatis-thymeleaf.config.file", "mybatis-thymeleaf.properties"));
    }

    private static Properties loadProperties(String resourcePath) {
        Properties properties = new Properties();
        Optional.ofNullable(ClassLoaderUtils.findResourceAsStream((String)resourcePath)).ifPresent(in -> {
            Charset encoding = Optional.ofNullable(System.getProperty("mybatis-thymeleaf.config.encoding")).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            try (InputStreamReader inReader = new InputStreamReader((InputStream)in, encoding);
                 BufferedReader bufReader = new BufferedReader(inReader);){
                properties.load(bufReader);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        return properties;
    }

    private static Class<?> toClassForName(String value) {
        try {
            return ClassLoaderUtils.loadClass((String)value.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        HashMap<Class<Object>, Function<String, Object>> converters = new HashMap<Class<Object>, Function<String, Object>>();
        converters.put(Boolean.TYPE, v -> Boolean.valueOf(v.trim()));
        converters.put(String.class, String::trim);
        converters.put(Character[].class, v -> Stream.of(v.split(",")).map(String::trim).filter(e -> e.length() == 1).map(e -> Character.valueOf(e.charAt(0))).toArray(Character[]::new));
        converters.put(Character.class, v -> Character.valueOf(v.trim().charAt(0)));
        converters.put(Charset.class, v -> Charset.forName(v.trim()));
        converters.put(Long.class, v -> Long.valueOf(v.trim()));
        converters.put(String[].class, v -> Stream.of(v.split(",")).map(String::trim).toArray(String[]::new));
        converters.put(Class.class, SqlGeneratorConfig::toClassForName);
        TYPE_CONVERTERS = Collections.unmodifiableMap(converters);
    }

    public static class TemplateFileConfig {
        private Charset encoding = StandardCharsets.UTF_8;
        private String baseDir = "";
        private String[] patterns = new String[]{"*.sql"};
        private boolean cacheEnabled = true;
        private Long cacheTtl;

        public Charset getEncoding() {
            return this.encoding;
        }

        public void setEncoding(Charset encoding) {
            this.encoding = encoding;
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public void setPatterns(String ... patterns) {
            this.patterns = patterns;
        }

        public boolean isCacheEnabled() {
            return this.cacheEnabled;
        }

        public void setCacheEnabled(boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
        }

        public Long getCacheTtl() {
            return this.cacheTtl;
        }

        public void setCacheTtl(Long cacheTtl) {
            this.cacheTtl = cacheTtl;
        }
    }

    public static class DialectConfig {
        private String prefix = "mb";
        private Character likeEscapeChar = Character.valueOf('\\');
        private String likeEscapeClauseFormat = "ESCAPE '%s'";
        private Character[] likeAdditionalEscapeTargetChars;
        private BindVariableRender bindVariableRender;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Character getLikeEscapeChar() {
            return this.likeEscapeChar;
        }

        public void setLikeEscapeChar(Character likeEscapeChar) {
            this.likeEscapeChar = likeEscapeChar;
        }

        public String getLikeEscapeClauseFormat() {
            return this.likeEscapeClauseFormat;
        }

        public void setLikeEscapeClauseFormat(String likeEscapeClauseFormat) {
            this.likeEscapeClauseFormat = likeEscapeClauseFormat;
        }

        public Character[] getLikeAdditionalEscapeTargetChars() {
            return this.likeAdditionalEscapeTargetChars;
        }

        public void setLikeAdditionalEscapeTargetChars(Character ... likeAdditionalEscapeTargetChars) {
            this.likeAdditionalEscapeTargetChars = likeAdditionalEscapeTargetChars;
        }

        @Deprecated
        public Class<? extends BindVariableRender> getBindVariableRender() {
            return this.bindVariableRender == null ? null : this.bindVariableRender.getClass();
        }

        @Deprecated
        public void setBindVariableRender(Class<? extends BindVariableRender> bindVariableRender) {
            this.bindVariableRender = SqlGeneratorConfig.newInstanceForType(bindVariableRender);
        }

        public BindVariableRender getBindVariableRenderInstance() {
            return this.bindVariableRender;
        }

        public void setBindVariableRenderInstance(BindVariableRender bindVariableRender) {
            this.bindVariableRender = bindVariableRender;
        }
    }

    private static class PropertyKeys {
        private static final String CONFIG_FILE = "mybatis-thymeleaf.config.file";
        private static final String CONFIG_ENCODING = "mybatis-thymeleaf.config.encoding";

        private PropertyKeys() {
        }
    }

    private static class Defaults {
        private static final String PROPERTIES_FILE = "mybatis-thymeleaf.properties";

        private Defaults() {
        }
    }
}

