/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.BuilderException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.mybatis.scripting.velocity.InDirective;
import org.mybatis.scripting.velocity.RepeatDirective;
import org.mybatis.scripting.velocity.SetDirective;
import org.mybatis.scripting.velocity.TrimDirective;
import org.mybatis.scripting.velocity.WhereDirective;

public class VelocityFacade {
    private static final String ADDITIONAL_CTX_ATTRIBUTES_KEY = "additional.context.attributes";
    private static final String EXTERNAL_PROPERTIES = "mybatis-velocity.properties";
    private static final String DIRECTIVES = TrimDirective.class.getName() + "," + WhereDirective.class.getName() + "," + SetDirective.class.getName() + "," + InDirective.class.getName() + "," + RepeatDirective.class.getName();
    private static final RuntimeInstance engine;
    private static final Map<String, Object> additionalCtxAttributes;
    private static final Properties settings;

    private VelocityFacade() {
    }

    public static Object compile(String script, String name) {
        try {
            StringReader reader = new StringReader(script);
            Template template = new Template();
            SimpleNode node = engine.parse((Reader)reader, template);
            template.setRuntimeServices((RuntimeServices)engine);
            template.setData((Object)node);
            template.setName(name);
            template.initDocument();
            return template;
        }
        catch (Exception ex) {
            throw new BuilderException("Error parsing velocity script '" + name + "'", (Throwable)ex);
        }
    }

    public static String apply(Object template, Map<String, Object> context) {
        StringWriter out = new StringWriter();
        context.putAll(additionalCtxAttributes);
        ((Template)template).merge((Context)new VelocityContext(context), (Writer)out);
        return out.toString();
    }

    private static Properties loadProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            props.load(cl.getResourceAsStream(EXTERNAL_PROPERTIES));
        }
        catch (Exception cl) {
            // empty catch block
        }
        String userDirective = StringUtils.trim((String)props.getProperty("userdirective"));
        userDirective = userDirective == null ? DIRECTIVES : userDirective + "," + DIRECTIVES;
        props.setProperty("userdirective", userDirective);
        return props;
    }

    private static Map<String, Object> loadAdditionalCtxAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String additionalContextAttributes = settings.getProperty(ADDITIONAL_CTX_ATTRIBUTES_KEY);
        if (additionalContextAttributes == null) {
            return attributes;
        }
        try {
            String[] entries;
            for (String str : entries = additionalContextAttributes.split(",")) {
                String[] entry = str.trim().split(":");
                attributes.put(entry[0].trim(), Class.forName(entry[1].trim()).newInstance());
            }
        }
        catch (Exception ex) {
            throw new BuilderException("Error parsing velocity property 'additional.context.attributes'", (Throwable)ex);
        }
        return attributes;
    }

    static {
        settings = VelocityFacade.loadProperties();
        additionalCtxAttributes = Collections.unmodifiableMap(VelocityFacade.loadAdditionalCtxAttributes());
        engine = new RuntimeInstance();
        engine.init(settings);
    }
}

