/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.text.WordUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.ScriptingException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mybatis.scripting.velocity.InDirective;
import org.mybatis.scripting.velocity.RepeatDirective;
import org.mybatis.scripting.velocity.SetDirective;
import org.mybatis.scripting.velocity.TrimDirective;
import org.mybatis.scripting.velocity.WhereDirective;

public class VelocityLanguageDriverConfig {
    private static final String PROPERTY_KEY_CONFIG_FILE = "mybatis-velocity.config.file";
    private static final String PROPERTY_KEY_CONFIG_ENCODING = "mybatis-velocity.config.encoding";
    private static final String DEFAULT_PROPERTIES_FILE = "mybatis-velocity.properties";
    private static final String PROPERTY_KEY_ADDITIONAL_CONTEXT_ATTRIBUTE = "additional.context.attributes";
    private static final String[] BUILT_IN_DIRECTIVES = new String[]{TrimDirective.class.getName(), WhereDirective.class.getName(), SetDirective.class.getName(), InDirective.class.getName(), RepeatDirective.class.getName()};
    private static final Map<Class<?>, Function<String, Object>> TYPE_CONVERTERS;
    private static final Log log;
    private final Map<String, String> velocitySettings = new HashMap<String, String>();
    private String[] userDirectives;
    private final Map<String, String> additionalContextAttributes;

    public VelocityLanguageDriverConfig() {
        this.velocitySettings.put("resource.loaders", "class");
        this.velocitySettings.put("resource.loader.class.class", ClasspathResourceLoader.class.getName());
        this.userDirectives = new String[0];
        this.additionalContextAttributes = new HashMap<String, String>();
    }

    public Map<String, String> getVelocitySettings() {
        return this.velocitySettings;
    }

    @Deprecated
    public String[] getUserdirective() {
        return this.userDirectives;
    }

    @Deprecated
    public void setUserdirective(String ... userDirectives) {
        log.warn("The 'userdirective' has been deprecated since 2.1.0. Please use the 'velocity-settings.runtime.custom_directives' or 'runtime.custom_directives'.");
        this.userDirectives = userDirectives;
    }

    public Map<String, String> getAdditionalContextAttributes() {
        return this.additionalContextAttributes;
    }

    public String generateCustomDirectivesString() {
        StringJoiner customDirectivesJoiner = new StringJoiner(",");
        Optional.ofNullable(this.velocitySettings.get("runtime.custom_directives")).ifPresent(customDirectivesJoiner::add);
        Stream.of(this.userDirectives).forEach(customDirectivesJoiner::add);
        Stream.of(BUILT_IN_DIRECTIVES).forEach(customDirectivesJoiner::add);
        return customDirectivesJoiner.toString();
    }

    public static VelocityLanguageDriverConfig newInstance() {
        return VelocityLanguageDriverConfig.newInstance(VelocityLanguageDriverConfig.loadDefaultProperties());
    }

    public static VelocityLanguageDriverConfig newInstance(Properties customProperties) {
        VelocityLanguageDriverConfig config = new VelocityLanguageDriverConfig();
        Properties properties = VelocityLanguageDriverConfig.loadDefaultProperties();
        Optional.ofNullable(customProperties).ifPresent(properties::putAll);
        VelocityLanguageDriverConfig.override(config, properties);
        VelocityLanguageDriverConfig.configureVelocitySettings(config, properties);
        return config;
    }

    public static VelocityLanguageDriverConfig newInstance(Consumer<VelocityLanguageDriverConfig> customizer) {
        VelocityLanguageDriverConfig config = new VelocityLanguageDriverConfig();
        Properties properties = VelocityLanguageDriverConfig.loadDefaultProperties();
        customizer.accept(config);
        VelocityLanguageDriverConfig.override(config, properties);
        VelocityLanguageDriverConfig.configureVelocitySettings(config, properties);
        return config;
    }

    private static void override(VelocityLanguageDriverConfig config, Properties properties) {
        VelocityLanguageDriverConfig.enableLegacyAdditionalContextAttributes(properties);
        MetaObject metaObject = MetaObject.forObject((Object)config, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        HashSet consumedKeys = new HashSet();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String propertyPath = WordUtils.uncapitalize((String)WordUtils.capitalize((String)Objects.toString(key), (char[])new char[]{'-'}).replaceAll("-", ""));
            if (metaObject.hasSetter(propertyPath)) {
                PropertyTokenizer pt = new PropertyTokenizer(propertyPath);
                if (Map.class.isAssignableFrom(metaObject.getGetterType(pt.getName()))) {
                    Map map = (Map)metaObject.getValue(pt.getName());
                    map.put(pt.getChildren(), value);
                } else {
                    Optional.ofNullable(value).ifPresent(v -> {
                        Object convertedValue = TYPE_CONVERTERS.get(metaObject.getSetterType(propertyPath)).apply(value.toString());
                        metaObject.setValue(propertyPath, convertedValue);
                    });
                }
                consumedKeys.add(key);
            }
        }));
        consumedKeys.forEach(properties::remove);
    }

    private static void enableLegacyAdditionalContextAttributes(Properties properties) {
        String additionalContextAttributes = properties.getProperty(PROPERTY_KEY_ADDITIONAL_CONTEXT_ATTRIBUTE);
        if (Objects.nonNull(additionalContextAttributes)) {
            log.warn(String.format("The '%s' has been deprecated since 2.1.0. Please use the 'additionalContextAttributes.{name}={value}'.", PROPERTY_KEY_ADDITIONAL_CONTEXT_ATTRIBUTE));
            Stream.of(additionalContextAttributes.split(",")).forEach(pair -> {
                String[] keyValue = pair.split(":");
                if (keyValue.length != 2) {
                    throw new ScriptingException("Invalid additional context property '" + pair + "' on 'additional.context.attributes'. Must be specify by 'key:value' format.");
                }
                properties.setProperty("additional-context-attributes." + keyValue[0].trim(), keyValue[1].trim());
            });
            properties.remove(PROPERTY_KEY_ADDITIONAL_CONTEXT_ATTRIBUTE);
        }
    }

    private static void configureVelocitySettings(VelocityLanguageDriverConfig config, Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> config.getVelocitySettings().put((String)name, (String)value)));
    }

    private static Properties loadDefaultProperties() {
        return VelocityLanguageDriverConfig.loadProperties(System.getProperty(PROPERTY_KEY_CONFIG_FILE, DEFAULT_PROPERTIES_FILE));
    }

    private static Properties loadProperties(String resourcePath) {
        InputStream in;
        Properties properties = new Properties();
        try {
            in = Resources.getResourceAsStream((String)resourcePath);
        }
        catch (IOException e) {
            in = null;
        }
        if (in != null) {
            Charset encoding = Optional.ofNullable(System.getProperty(PROPERTY_KEY_CONFIG_ENCODING)).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            try (InputStreamReader inReader = new InputStreamReader(in, encoding);
                 BufferedReader bufReader = new BufferedReader(inReader);){
                properties.load(bufReader);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return properties;
    }

    static {
        HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
        converters.put(String.class, String::trim);
        converters.put(Charset.class, v -> Charset.forName(v.trim()));
        converters.put(String[].class, v -> Stream.of(v.split(",")).map(String::trim).toArray(String[]::new));
        converters.put(Object.class, v -> v);
        TYPE_CONVERTERS = Collections.unmodifiableMap(converters);
        log = LogFactory.getLog(VelocityLanguageDriverConfig.class);
    }
}

