/*
 * Decompiled with CFR 0.152.
 */
package org.hotwheel.json;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.hotwheel.assembly.Api;
import org.hotwheel.json.impl.jackson.JacksonParser;
import org.hotwheel.json.impl.jackson.JsonFactory;
import org.hotwheel.json.impl.jackson.JsonParseException;
import org.hotwheel.json.impl.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAdapter {
    private static Logger logger = LoggerFactory.getLogger(JsonAdapter.class);
    private JacksonParser parser = null;

    private JsonAdapter(JacksonParser parser, boolean verbose) {
        this.parser = parser;
    }

    public static JsonAdapter parse(String string) {
        return JsonAdapter.parse(string, false);
    }

    public static JsonAdapter parse(String string, boolean verbose) {
        JsonAdapter ret = null;
        if (!Api.isEmpty((String)string)) {
            JsonFactory factory = new JsonFactory();
            JacksonParser jp = null;
            try {
                jp = factory.createJsonParser(string);
            }
            catch (JsonParseException e) {
                logger.error("", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            if (jp != null) {
                ret = new JsonAdapter(jp, verbose);
            }
        }
        return ret;
    }

    private static Class<?> getGenericClass(Object obj) {
        Class gcRet = null;
        Class<?> clazz = obj.getClass();
        Type tg = clazz.getGenericSuperclass();
        if (tg != null) {
            try {
                ParameterizedType pType = (ParameterizedType)tg;
                Type[] ts = pType.getActualTypeArguments();
                if (ts != null && ts.length > 0) {
                    gcRet = (Class)ts[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gcRet;
    }

    private static <T> String getList(List<T> list, boolean toLower) {
        String sRet = null;
        if (list != null) {
            StringBuffer buffer = new StringBuffer();
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                T obj = list.get(i);
                String s = JsonAdapter.get(obj, toLower);
                buffer.append(s);
                if (i + 1 >= count) continue;
                buffer.append(",");
            }
            sRet = buffer.toString();
        }
        return sRet;
    }

    private static <T> String getArray(Object array, boolean toLower) {
        String sRet = null;
        if (array != null) {
            StringBuffer buffer = new StringBuffer();
            int count = Array.getLength(array);
            for (int i = 0; i < count; ++i) {
                Object obj = Array.get(array, i);
                String s = null;
                s = obj == null ? "" : (Api.isBaseType((Object)obj) ? Api.toString((Object)obj) : JsonAdapter.get(obj, toLower));
                if (obj instanceof String) {
                    s = "\"" + s.replaceAll("\"", "\\\\\"") + "\"";
                }
                buffer.append(s);
                if (i + 1 >= count) continue;
                buffer.append(",");
            }
            sRet = buffer.toString();
        }
        return sRet;
    }

    public static String get(Object obj) {
        String sRet = "";
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            sRet = Api.isInterface(clazz, List.class) ? '[' + JsonAdapter.getList((List)obj, false) + ']' : (clazz.isArray() ? '[' + JsonAdapter.getArray(obj, false) + ']' : JsonAdapter.get(obj, false));
        }
        return sRet;
    }

    private static String string2Json(String s) {
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(Object obj, boolean toLower) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        Class<Object> clazz = null;
        Field[] fields = null;
        Field field = null;
        String name = null;
        Object value = null;
        Class<?> cls = null;
        Package clsPackage = null;
        String clsPrefix = null;
        boolean isAccessible = false;
        while (obj != null && !(clazz = clazz == null ? obj.getClass() : clazz.getSuperclass()).getName().startsWith("java")) {
            fields = clazz.getDeclaredFields();
            field = null;
            String sub = null;
            for (int j = 0; j < fields.length; ++j) {
                field = fields[j];
                cls = field.getType();
                name = field.getName().trim();
                if (name.equalsIgnoreCase("serialVersionUID") || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                buffer.append("\"");
                buffer.append(toLower ? name.toLowerCase() : name);
                buffer.append("\":");
                isAccessible = field.isAccessible();
                clsPackage = cls.getPackage();
                clsPrefix = clsPackage == null ? null : clsPackage.getName();
                try {
                    field.setAccessible(true);
                    value = field.get(obj);
                    if (value == null && (clsPrefix == null || clsPrefix.startsWith("java"))) {
                        value = Api.valueOf(cls, (String)"");
                    }
                    if (cls == Date.class || cls == java.util.Date.class) {
                        value = Api.toString((Object)value);
                    }
                    if (value instanceof Object && Api.isInterface(value.getClass(), List.class)) {
                        buffer.append("[");
                        sub = JsonAdapter.getList((List)value, toLower);
                        if (sub != null) {
                            buffer.append(sub);
                        }
                        buffer.append("]");
                    } else if (cls.isArray() || cls == List.class) {
                        buffer.append("[");
                        sub = JsonAdapter.getArray(value, toLower);
                        if (sub != null) {
                            buffer.append(sub);
                        }
                        buffer.append("]");
                    } else if (value != null && value.getClass().isArray()) {
                        buffer.append("[");
                        sub = JsonAdapter.getArray(value, toLower);
                        if (sub != null) {
                            buffer.append(sub);
                        }
                        buffer.append("]");
                    } else if (value instanceof String) {
                        buffer.append("\"");
                        buffer.append(JsonAdapter.string2Json((String)value));
                        buffer.append("\"");
                    } else if (!Api.isBaseType(cls) || !Api.isBaseType((Object)value)) {
                        if (value != null) {
                            sub = JsonAdapter.get(value, toLower);
                            buffer.append(sub);
                        } else {
                            buffer.append("{}");
                        }
                    } else {
                        buffer.append(value);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.error("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error("", (Throwable)e);
                }
                finally {
                    field.setAccessible(isAccessible);
                }
                if (j + 1 < fields.length) {
                    buffer.append(",");
                    continue;
                }
                if (clazz.getSuperclass().getName().startsWith("java") || clazz.getSuperclass().getDeclaredFields().length <= 0) continue;
                buffer.append(",");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private <T> List<T> parseList(Class<T> clazz) {
        ArrayList<T> list = null;
        try {
            JsonToken token = null;
            String fieldName = this.parser.getCurrentName();
            if (fieldName == null) {
                this.parser.nextToken();
            }
            while ((token = this.parser.nextToken()) != JsonToken.END_ARRAY) {
                Object obj;
                fieldName = this.parser.getCurrentName();
                if (token == JsonToken.START_ARRAY || token == JsonToken.END_ARRAY) continue;
                if (token == JsonToken.START_OBJECT) {
                    obj = this.get(clazz);
                    if (obj == null) continue;
                    if (list == null) {
                        list = new ArrayList<T>();
                    }
                    list.add(obj);
                    continue;
                }
                if (token == JsonToken.VALUE_STRING || token.isScalarValue()) {
                    obj = Api.valueOf(clazz, (String)this.parser.getText());
                    if (obj == null) continue;
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(obj);
                    continue;
                }
                if (token == JsonToken.END_OBJECT || token == JsonToken.END_ARRAY || token == JsonToken.FIELD_NAME || fieldName == null) continue;
            }
        }
        catch (JsonParseException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return list;
    }

    public <T> T get(Class<T> clazz) {
        Object[] obj = null;
        if (clazz.isArray()) {
            Class<?> cls = clazz.getComponentType();
            List<?> list = this.parseList(cls);
            if (list != null) {
                obj = list.toArray();
            }
        } else {
            obj = (Object[])this.get(clazz, null);
        }
        return (T)obj;
    }

    public <T> T get(Class<T> clazz, Class<?> claee) {
        T tRet = null;
        try {
            JsonToken token = null;
            String fieldName = this.parser.getCurrentName();
            String fieldValue = null;
            Package clsPackage = null;
            String clsPrefix = null;
            if (fieldName == null) {
                this.parser.nextToken();
            }
            while ((token = this.parser.nextToken()) != JsonToken.END_OBJECT) {
                if (tRet == null) {
                    try {
                        tRet = clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                fieldName = this.parser.getCurrentName();
                fieldValue = token == JsonToken.VALUE_NULL ? null : this.parser.getText();
                Class<?> cls = Api.getClass(clazz, (String)fieldName);
                if (cls == null) {
                    this.parser.skipChildren();
                    continue;
                }
                if (cls == List.class) {
                    cls = claee;
                } else if (claee != null && cls == Object.class) {
                    cls = claee;
                }
                clsPackage = cls != null ? cls.getPackage() : null;
                clsPrefix = clsPackage == null ? null : clsPackage.getName();
                if (token == JsonToken.START_ARRAY) {
                    int i;
                    Object arr;
                    List<?> list;
                    if (cls == null) continue;
                    boolean isArray = false;
                    if (cls.isArray()) {
                        cls = cls.getComponentType();
                        isArray = true;
                    }
                    if ((list = this.parseList(cls)) == null) {
                        arr = null;
                        arr = isArray && cls != null ? Array.newInstance(cls, 0) : null;
                        Api.setValue(tRet, (String)fieldName, (Object)arr);
                        continue;
                    }
                    if (!isArray) {
                        Api.setValue(tRet, (String)fieldName, list);
                        continue;
                    }
                    arr = null;
                    if (list.get(0).getClass() == cls) {
                        arr = Array.newInstance(cls, list.size());
                        for (i = 0; i < list.size(); ++i) {
                            Array.set(arr, i, list.get(i));
                        }
                    } else {
                        arr = Array.newInstance(cls, list.size());
                        for (i = 0; i < list.size(); ++i) {
                            Array.set(arr, i, list.get(i));
                        }
                    }
                    Api.setValue(tRet, (String)fieldName, (Object)arr);
                    continue;
                }
                if (token == JsonToken.END_ARRAY) continue;
                if (token == JsonToken.START_OBJECT) {
                    Object obj;
                    if (cls == null || (obj = this.get(cls, claee)) == null) continue;
                    Api.setValue(tRet, (String)fieldName, obj);
                    continue;
                }
                if (token == JsonToken.END_OBJECT || token == JsonToken.END_ARRAY || token == JsonToken.FIELD_NAME || token == null || fieldName == null || clsPrefix != null && !clsPrefix.startsWith("java")) continue;
                Object tmpObj = fieldValue;
                if (Api.isBaseDataType(cls)) {
                    tmpObj = Api.valueOf(cls, (String)fieldValue);
                } else if (token == JsonToken.VALUE_STRING) {
                    tmpObj = fieldValue;
                } else if (token == JsonToken.VALUE_NUMBER_INT) {
                    tmpObj = Api.valueOf(Integer.TYPE, (String)fieldValue);
                } else if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                    tmpObj = Api.valueOf(Float.class, (String)fieldValue);
                } else if (token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
                    tmpObj = Api.valueOf(Boolean.class, (String)fieldValue);
                } else if (cls instanceof Object && claee != null && claee.isArray()) {
                    Object arr = null;
                    if (fieldValue == null) {
                        arr = Array.newInstance(claee.getComponentType(), 0);
                    }
                    tmpObj = arr;
                }
                Api.setValue(tRet, (String)fieldName, (Object)tmpObj);
            }
        }
        catch (JsonParseException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return tRet;
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

