/*
 * Decompiled with CFR 0.152.
 */
package org.hotwheel.json.impl.jackson;

import java.util.LinkedHashMap;
import java.util.Map;

public final class InternCache
extends LinkedHashMap<String, String> {
    public static final InternCache instance = new InternCache();
    private static final int MAX_ENTRIES = 192;

    private InternCache() {
        super(192, 0.8f, true);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
        return this.size() > 192;
    }

    public synchronized String intern(String input) {
        String result = (String)this.get(input);
        if (result == null) {
            result = input.intern();
            this.put(result, result);
        }
        return result;
    }
}

