/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.client.services.development.exceptionthrower;

import org.nameapi.client.services.development.exceptionthrower.ExceptionType;

public class ExceptionThrowerParams {
    private final ExceptionType exceptionType;
    private final int exceptionChance;

    public ExceptionThrowerParams(ExceptionType exceptionType, int exceptionChance) {
        ExceptionThrowerParams.checkNumber(exceptionChance);
        this.exceptionType = exceptionType;
        this.exceptionChance = exceptionChance;
    }

    private static void checkNumber(int exceptionChance) {
        if (exceptionChance < 0 || exceptionChance > 100) {
            throw new IllegalArgumentException("Chance must be 0-100 but was: " + exceptionChance);
        }
    }

    public ExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public int getExceptionChance() {
        return this.exceptionChance;
    }

    public static class Builder {
        private ExceptionType exceptionType;
        private int exceptionChance = 100;

        public Builder exceptionType(ExceptionType exceptionType) {
            this.exceptionType = exceptionType;
            return this;
        }

        public Builder exceptionChance(int exceptionChance) {
            ExceptionThrowerParams.checkNumber(exceptionChance);
            this.exceptionChance = exceptionChance;
            return this;
        }

        public ExceptionThrowerParams build() {
            if (this.exceptionType == null) {
                throw new IllegalStateException("Exception type not specified!");
            }
            return new ExceptionThrowerParams(this.exceptionType, this.exceptionChance);
        }
    }
}

