/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.client.services.nameparser;

import com.google.common.base.Optional;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nameapi.client.services.nameparser.Match;
import org.nameapi.ontology5.cremalang.annotation.Immutable;

@Immutable
public class NameParserResult {
    @NotNull
    private final Optional<Match> bestMatch;
    @NotNull
    private final List<Match> matches;
    private final int shortestItemCount;

    public NameParserResult(@Nullable Match bestMatch, @NotNull List<Match> matches, int shortestItemCount) {
        this.bestMatch = Optional.fromNullable((Object)bestMatch);
        this.matches = matches;
        this.shortestItemCount = shortestItemCount;
    }

    @NotNull
    public Optional<Match> getBestMatch() {
        return this.bestMatch;
    }

    @NotNull
    public List<Match> getMatches() {
        return this.matches;
    }

    public int getShortestItemCount() {
        return this.shortestItemCount;
    }

    public String toString() {
        return "ParserResult{bestMatch=" + this.bestMatch + ", matches=" + this.matches + ", shortestItemCount=" + this.shortestItemCount + '}';
    }
}

