/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.error;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.error.ExceptionAdviceRegistry;
import org.namul.api.payload.error.configurer.ExceptionAdviceConfigurer;
import org.namul.api.payload.handler.ExceptionAdviceHandler;
import org.namul.api.payload.log.ExceptionAdviceLogger;
import org.namul.api.payload.message.ExceptionAdviceMessageManager;
import org.namul.api.payload.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionAdvice<R extends ErrorReasonDTO> {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);
    private final ExceptionAdviceConfigurer<R> exceptionAdviceConfigurer;
    private final ExceptionAdviceLogger exceptionAdviceLogger;
    private final ExceptionAdviceMessageManager exceptionAdviceMessageManager;

    @ExceptionHandler
    public <E extends Exception> BaseResponse handle(E e, HttpServletRequest request, HttpServletResponse response) {
        ExceptionAdviceRegistry registry = this.exceptionAdviceConfigurer.findRegistry(e.getClass());
        if (registry == null) {
            throw new IllegalArgumentException("The appropriate handler was not found.");
        }
        this.exceptionAdviceMessageManager.sendMessageAsync(request, registry.getCls(), e);
        return this.handleDelegated(e, request, response, registry);
    }

    private <E extends Exception> BaseResponse handleDelegated(E e, HttpServletRequest request, HttpServletResponse response, ExceptionAdviceRegistry<E, R> registry) {
        R reasonDTO = registry.getErrorReasonDTO();
        ExceptionAdviceHandler<E, R> handler = registry.getHandler();
        response.setStatus(reasonDTO.getHttpStatus().value());
        this.exceptionAdviceLogger.log(e, reasonDTO, handler.getMessage(e, reasonDTO));
        return handler.handleException(e, request, response, reasonDTO);
    }

    public ExceptionAdvice(ExceptionAdviceConfigurer<R> exceptionAdviceConfigurer, ExceptionAdviceLogger exceptionAdviceLogger, ExceptionAdviceMessageManager exceptionAdviceMessageManager) {
        this.exceptionAdviceConfigurer = exceptionAdviceConfigurer;
        this.exceptionAdviceLogger = exceptionAdviceLogger;
        this.exceptionAdviceMessageManager = exceptionAdviceMessageManager;
    }
}

