/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.error.configurer;

import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.Map;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.error.ExceptionAdviceRegistry;
import org.namul.api.payload.error.exception.ServerApplicationException;
import org.namul.api.payload.handler.ConstraintViolationExceptionHandler;
import org.namul.api.payload.handler.ExceptionAdviceHandler;
import org.namul.api.payload.handler.GlobalExceptionHandler;
import org.namul.api.payload.handler.MethodArgumentNotValidExceptionHandler;
import org.namul.api.payload.handler.ServerApplicationExceptionHandler;
import org.namul.api.payload.writer.FailureResponseWriter;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class ExceptionAdviceConfigurer<R extends ErrorReasonDTO> {
    private final Map<Class<? extends Exception>, ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO>> adviceMap = new HashMap<Class<? extends Exception>, ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO>>();
    private final FailureResponseWriter<R> failureResponseWriter;

    public void withDefault(R constraintReasonDTO, R methodArgumentReasonDTO, R serverApplicationReasonDTO, R exceptionReasonDTO) {
        this.addConstraintViolation(constraintReasonDTO);
        this.addMethodArgumentNotValid(methodArgumentReasonDTO);
        this.addServerApplication(serverApplicationReasonDTO);
        this.addGlobalException(exceptionReasonDTO);
    }

    public void addConstraintViolation(ExceptionAdviceHandler<ConstraintViolationException, R> handler, R r) {
        this.addAdvice(ConstraintViolationException.class, handler, r);
    }

    public void addMethodArgumentNotValid(ExceptionAdviceHandler<MethodArgumentNotValidException, R> handler, R r) {
        this.addAdvice(MethodArgumentNotValidException.class, handler, r);
    }

    public void addServerApplication(ExceptionAdviceHandler<ServerApplicationException, R> handler, R r) {
        this.addAdvice(ServerApplicationException.class, handler, r);
    }

    public void addGlobalException(ExceptionAdviceHandler<Exception, R> handler, R r) {
        this.addAdvice(Exception.class, handler, r);
    }

    public void addConstraintViolation(R r) {
        this.addAdvice(ConstraintViolationException.class, new ConstraintViolationExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addMethodArgumentNotValid(R r) {
        this.addAdvice(MethodArgumentNotValidException.class, new MethodArgumentNotValidExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addServerApplication(R r) {
        this.addAdvice(ServerApplicationException.class, new ServerApplicationExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addGlobalException(R r) {
        this.addAdvice(Exception.class, new GlobalExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public <E extends Exception> void addAdvice(Class<E> cls, ExceptionAdviceHandler<E, R> handler, R r) {
        this.adviceMap.put(cls, new ExceptionAdviceRegistry<E, R>(cls, handler, r));
    }

    public <E extends Exception> void deleteAdvice(Class<E> cls) {
        this.adviceMap.remove(cls);
    }

    public <E extends Exception> ExceptionAdviceRegistry<E, R> findRegistry(Class<? extends Exception> exceptionClass) {
        for (Class<? extends Exception> current = exceptionClass; current != null && Exception.class.isAssignableFrom(current); current = current.getSuperclass()) {
            ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO> registry = this.adviceMap.get(current);
            if (registry == null) continue;
            return registry;
        }
        return null;
    }

    public ExceptionAdviceConfigurer(FailureResponseWriter<R> failureResponseWriter) {
        this.failureResponseWriter = failureResponseWriter;
    }
}

