/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.handler.ExceptionAdviceHandler;
import org.namul.api.payload.response.BaseResponse;
import org.namul.api.payload.writer.FailureResponseWriter;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class MethodArgumentNotValidExceptionHandler<R extends ErrorReasonDTO>
implements ExceptionAdviceHandler<MethodArgumentNotValidException, R> {
    private final FailureResponseWriter<R> failureResponseWriter;

    @Override
    public BaseResponse handleException(MethodArgumentNotValidException e, HttpServletRequest request, HttpServletResponse response, R errorReasonDTO) {
        Object message = this.getMessage(e, errorReasonDTO);
        return this.failureResponseWriter.onFailure(errorReasonDTO, message);
    }

    @Override
    public Object getMessage(MethodArgumentNotValidException e, R errorReasonDTO) {
        LinkedHashMap errors = new LinkedHashMap();
        e.getBindingResult().getFieldErrors().forEach(fieldError -> {
            String fieldName = fieldError.getField();
            String errorMessage = Optional.ofNullable(fieldError.getDefaultMessage()).orElse("");
            errors.merge(fieldName, errorMessage, (existingErrorMessage, newErrorMessage) -> existingErrorMessage + ", " + newErrorMessage);
        });
        return errors;
    }

    public MethodArgumentNotValidExceptionHandler(FailureResponseWriter<R> failureResponseWriter) {
        this.failureResponseWriter = failureResponseWriter;
    }
}

