/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.error.exception.ServerApplicationException;
import org.namul.api.payload.handler.ExceptionAdviceHandler;
import org.namul.api.payload.response.BaseResponse;
import org.namul.api.payload.writer.FailureResponseWriter;

public class ServerApplicationExceptionHandler<R extends ErrorReasonDTO>
implements ExceptionAdviceHandler<ServerApplicationException, R> {
    private final FailureResponseWriter<R> failureResponseWriter;

    @Override
    public BaseResponse handleException(ServerApplicationException e, HttpServletRequest request, HttpServletResponse response, R errorReasonDTO) {
        try {
            ErrorReasonDTO errorReason = e.getErrorReason();
            return this.failureResponseWriter.onFailure(errorReason, null);
        }
        catch (ClassCastException classCastException) {
            return this.failureResponseWriter.onFailure(errorReasonDTO, null);
        }
    }

    @Override
    public Object getMessage(ServerApplicationException e, R errorReasonDTO) {
        return e.getCode();
    }

    public ServerApplicationExceptionHandler(FailureResponseWriter<R> failureResponseWriter) {
        this.failureResponseWriter = failureResponseWriter;
    }
}

