/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.namul.api.payload.message.ExceptionAdviceMessage;
import org.namul.api.payload.message.ExceptionAdviceMessageSender;
import org.namul.api.payload.message.generator.ExceptionAdviceMessageGenerator;

public class ExceptionAdviceMessageManager {
    private final List<ExceptionAdviceMessageSenderRegistry<?>> senders = new ArrayList();
    private final Executor executor = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public final <T extends ExceptionAdviceMessage> void addSender(ExceptionAdviceMessageSender<T> sender, ExceptionAdviceMessageGenerator<T> generator) {
        this.senders.add(new ExceptionAdviceMessageSenderRegistry<T>(sender, generator));
    }

    public void sendMessageAsync(HttpServletRequest request, Class<? extends Exception> cls, Exception e) {
        CompletableFuture.runAsync(() -> this.sendMessage(request, cls, e), this.executor);
    }

    public void sendMessage(HttpServletRequest request, Class<? extends Exception> cls, Exception e) {
        for (ExceptionAdviceMessageSenderRegistry<?> registry : this.senders) {
            registry.sendMessage(request, cls, e);
        }
    }

    public List<ExceptionAdviceMessageSenderRegistry<?>> getSenders() {
        return this.senders;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private static class ExceptionAdviceMessageSenderRegistry<T extends ExceptionAdviceMessage> {
        private final ExceptionAdviceMessageSender<T> sender;
        private final ExceptionAdviceMessageGenerator<T> generator;

        public <E extends Exception> void sendMessage(HttpServletRequest request, Class<E> cls, Exception e) {
            if (this.sender.isEnable(cls)) {
                this.sender.sendMessage(this.generator.createMessage(request, e));
            }
        }

        public ExceptionAdviceMessageSender<T> getSender() {
            return this.sender;
        }

        public ExceptionAdviceMessageGenerator<T> getGenerator() {
            return this.generator;
        }

        public ExceptionAdviceMessageSenderRegistry(ExceptionAdviceMessageSender<T> sender, ExceptionAdviceMessageGenerator<T> generator) {
            this.sender = sender;
            this.generator = generator;
        }
    }
}

