/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message.generator;

import jakarta.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import org.namul.api.payload.message.DiscordExceptionAdviceMessage;
import org.namul.api.payload.message.generator.ExceptionAdviceMessageGenerator;

public class DefaultDiscordExceptionAdviceMessageGenerator
implements ExceptionAdviceMessageGenerator<DiscordExceptionAdviceMessage> {
    private static final String DISCORD_CONTENT = "# \ud83d\udea8 Error";
    private static final String DISCORD_TITLE = "\u2139\ufe0f Error Info";
    private static final String DISCORD_DESCRIPTION_FORMAT = "### \ud83d\udd56 Time\n%s\n### \ud83d\udd17 Request URL\n%s\n### \ud83d\udcdd Message\n```\n%s\n```";
    private static final String DISCORD_STACK_TRACE_TITLE = "\ud83d\udcda Stack Trace";
    private static final String DISCORD_STACK_TRACE_DESCRIPTION_FORMAT = "```\n%s\n```";

    @Override
    public DiscordExceptionAdviceMessage createMessage(HttpServletRequest request, Exception exception) {
        String description = String.format(DISCORD_DESCRIPTION_FORMAT, LocalDateTime.now(), this.createRequestFullPath(request), this.getErrorMethodAndClass(exception));
        return DiscordExceptionAdviceMessage.from(DISCORD_CONTENT, DISCORD_TITLE, description, DISCORD_STACK_TRACE_TITLE, String.format(DISCORD_STACK_TRACE_DESCRIPTION_FORMAT, this.getStackTrace(exception).substring(0, 1000)));
    }

    private String createRequestFullPath(HttpServletRequest request) {
        String fullPath = request.getMethod() + " " + request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            fullPath = fullPath + "?" + queryString;
        }
        return fullPath;
    }

    private String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String getErrorMethodAndClass(Exception e) {
        StackTraceElement[] stackTraces = e.getStackTrace();
        if (stackTraces.length > 0) {
            StackTraceElement stackTrace = stackTraces[0];
            return "Method: " + stackTrace.getMethodName() + "\n Class: " + stackTrace.getClassName();
        }
        return null;
    }
}

