/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.namul.api.payload.code.DefaultResponseSuccessCode;
import org.namul.api.payload.code.dto.supports.DefaultResponseSuccessReasonDTO;
import org.namul.api.payload.response.AbstractBaseResponse;

@JsonPropertyOrder(value={"isSuccess", "code", "message", "result"})
public class DefaultResponse<T>
extends AbstractBaseResponse<T> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String code;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String message;
    @JsonProperty(value="isSuccess")
    private final Boolean isSuccess;

    public DefaultResponse(Boolean isSuccess, String code, String message, T result) {
        super(result);
        this.code = code;
        this.message = message;
        this.isSuccess = isSuccess;
    }

    public static <T> DefaultResponse<T> ok(T result) {
        return DefaultResponse.onSuccess(DefaultResponseSuccessCode._OK.getReason(), result);
    }

    public static <T> DefaultResponse<T> created(T result) {
        return DefaultResponse.onSuccess(DefaultResponseSuccessCode._CREATED.getReason(), result);
    }

    public static <T> DefaultResponse<T> noContent() {
        return DefaultResponse.onSuccess(DefaultResponseSuccessCode._DELETED.getReason(), null);
    }

    public static <T> DefaultResponse<T> onSuccess(DefaultResponseSuccessReasonDTO code, T result) {
        return new DefaultResponse<T>(code.isSuccess(), code.getCode(), code.getMessage(), result);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getIsSuccess() {
        return this.isSuccess;
    }
}

