/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.config;

import java.util.Optional;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.config.DiscordSenderAutoConfiguration;
import org.namul.api.payload.config.SlackSenderAutoConfiguration;
import org.namul.api.payload.error.ExceptionAdvice;
import org.namul.api.payload.error.configurer.ExceptionAdviceConfigurer;
import org.namul.api.payload.log.DefaultExceptionAdviceLogger;
import org.namul.api.payload.log.ExceptionAdviceLogger;
import org.namul.api.payload.message.DiscordExceptionAdviceMessage;
import org.namul.api.payload.message.DiscordExceptionAdviceMessageSender;
import org.namul.api.payload.message.ExceptionAdviceMessageManager;
import org.namul.api.payload.message.SlackExceptionAdviceMessage;
import org.namul.api.payload.message.SlackExceptionAdviceMessageSender;
import org.namul.api.payload.message.generator.DefaultDiscordExceptionAdviceMessageGenerator;
import org.namul.api.payload.message.generator.DefaultSlackExceptionAdviceMessageGenerator;
import org.namul.api.payload.message.generator.ExceptionAdviceMessageGenerator;
import org.namul.api.payload.writer.FailureResponseWriter;
import org.namul.api.payload.writer.supports.DefaultFailureResponseWriter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={DiscordSenderAutoConfiguration.class, SlackSenderAutoConfiguration.class})
public class ExceptionAdviceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={FailureResponseWriter.class})
    DefaultFailureResponseWriter defaultFailureResponseWriter() {
        return new DefaultFailureResponseWriter();
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionAdviceLogger.class})
    DefaultExceptionAdviceLogger defaultExceptionAdviceLogger() {
        return new DefaultExceptionAdviceLogger();
    }

    @Bean
    @ConditionalOnBean(value={ExceptionAdviceConfigurer.class})
    <R extends ErrorReasonDTO> ExceptionAdvice<R> exceptionAdvice(ExceptionAdviceConfigurer<R> exceptionAdviceConfigurer, ExceptionAdviceLogger exceptionAdviceLogger, ExceptionAdviceMessageManager exceptionAdviceMessageManager) {
        return new ExceptionAdvice<R>(exceptionAdviceConfigurer, exceptionAdviceLogger, exceptionAdviceMessageManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionAdviceMessageManager.class})
    ExceptionAdviceMessageManager exceptionAdviceMessageManager(DiscordExceptionAdviceMessageSender discordExceptionAdviceMessageSender, Optional<ExceptionAdviceMessageGenerator<DiscordExceptionAdviceMessage>> discordGeneratorOptional, SlackExceptionAdviceMessageSender slackExceptionAdviceMessageSender, Optional<ExceptionAdviceMessageGenerator<SlackExceptionAdviceMessage>> slackGeneratorOptional) {
        ExceptionAdviceMessageManager manager = new ExceptionAdviceMessageManager();
        manager.addSender(discordExceptionAdviceMessageSender, discordGeneratorOptional.orElseGet(DefaultDiscordExceptionAdviceMessageGenerator::new));
        manager.addSender(slackExceptionAdviceMessageSender, slackGeneratorOptional.orElseGet(DefaultSlackExceptionAdviceMessageGenerator::new));
        return manager;
    }
}

