/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.error.configurer;

import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.Map;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.error.ExceptionAdviceRegistry;
import org.namul.api.payload.error.exception.ServerApplicationException;
import org.namul.api.payload.handler.ConstraintViolationExceptionHandler;
import org.namul.api.payload.handler.ExceptionAdviceHandler;
import org.namul.api.payload.handler.GlobalExceptionHandler;
import org.namul.api.payload.handler.HttpMessageNotReadableExceptionHandler;
import org.namul.api.payload.handler.HttpRequestMethodNotSupportedExceptionHandler;
import org.namul.api.payload.handler.MethodArgumentNotValidExceptionHandler;
import org.namul.api.payload.handler.MissingPathVariableExceptionHandler;
import org.namul.api.payload.handler.MissingServletRequestParameterExceptionHandler;
import org.namul.api.payload.handler.NoResourceFoundExceptionHandler;
import org.namul.api.payload.handler.ServerApplicationExceptionHandler;
import org.namul.api.payload.handler.TypeMismatchExceptionHandler;
import org.namul.api.payload.writer.FailureResponseWriter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public class ExceptionAdviceConfigurer<R extends ErrorReasonDTO> {
    private final Map<Class<? extends Exception>, ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO>> adviceMap = new HashMap<Class<? extends Exception>, ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO>>();
    private final FailureResponseWriter<R> failureResponseWriter;

    public void withDefault(R badRequestError, R internalServerError) {
        this.addConstraintViolation(badRequestError);
        this.addMethodArgumentNotValid(badRequestError);
        this.addHttpMessageNotReadable(internalServerError);
        this.addHttpRequestMethodNotSupported(badRequestError);
        this.addMissingPathVariable(badRequestError);
        this.addMissingServletRequestParameter(badRequestError);
        this.addNoResourceFound(badRequestError);
        this.addTypeMismatch(badRequestError);
        this.addServerApplication(badRequestError);
        this.addGlobalException(internalServerError);
    }

    public void addConstraintViolation(ExceptionAdviceHandler<ConstraintViolationException, R> handler, R r) {
        this.addAdvice(ConstraintViolationException.class, handler, r);
    }

    public void addMethodArgumentNotValid(ExceptionAdviceHandler<MethodArgumentNotValidException, R> handler, R r) {
        this.addAdvice(MethodArgumentNotValidException.class, handler, r);
    }

    public void addHttpMessageNotReadable(ExceptionAdviceHandler<HttpMessageNotReadableException, R> handler, R r) {
        this.addAdvice(HttpMessageNotReadableException.class, handler, r);
    }

    public void addHttpRequestMethodNotSupported(ExceptionAdviceHandler<HttpRequestMethodNotSupportedException, R> handler, R r) {
        this.addAdvice(HttpRequestMethodNotSupportedException.class, handler, r);
    }

    public void addMissingPathVariable(ExceptionAdviceHandler<MissingPathVariableException, R> handler, R r) {
        this.addAdvice(MissingPathVariableException.class, handler, r);
    }

    public void addMissingServletRequestParameter(ExceptionAdviceHandler<MissingServletRequestParameterException, R> handler, R r) {
        this.addAdvice(MissingServletRequestParameterException.class, handler, r);
    }

    public void addNoResourceFound(ExceptionAdviceHandler<NoResourceFoundException, R> handler, R r) {
        this.addAdvice(NoResourceFoundException.class, handler, r);
    }

    public void addTypeMismatch(ExceptionAdviceHandler<TypeMismatchException, R> handler, R r) {
        this.addAdvice(TypeMismatchException.class, handler, r);
    }

    public void addServerApplication(ExceptionAdviceHandler<ServerApplicationException, R> handler, R r) {
        this.addAdvice(ServerApplicationException.class, handler, r);
    }

    public void addGlobalException(ExceptionAdviceHandler<Exception, R> handler, R r) {
        this.addAdvice(Exception.class, handler, r);
    }

    public void addConstraintViolation(R r) {
        this.addAdvice(ConstraintViolationException.class, new ConstraintViolationExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addMethodArgumentNotValid(R r) {
        this.addAdvice(MethodArgumentNotValidException.class, new MethodArgumentNotValidExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addHttpMessageNotReadable(R r) {
        this.addAdvice(HttpMessageNotReadableException.class, new HttpMessageNotReadableExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addHttpRequestMethodNotSupported(R r) {
        this.addAdvice(HttpRequestMethodNotSupportedException.class, new HttpRequestMethodNotSupportedExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addMissingPathVariable(R r) {
        this.addAdvice(MissingPathVariableException.class, new MissingPathVariableExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addMissingServletRequestParameter(R r) {
        this.addAdvice(MissingServletRequestParameterException.class, new MissingServletRequestParameterExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addNoResourceFound(R r) {
        this.addAdvice(NoResourceFoundException.class, new NoResourceFoundExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addTypeMismatch(R r) {
        this.addAdvice(TypeMismatchException.class, new TypeMismatchExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addServerApplication(R r) {
        this.addAdvice(ServerApplicationException.class, new ServerApplicationExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public void addGlobalException(R r) {
        this.addAdvice(Exception.class, new GlobalExceptionHandler<R>(this.failureResponseWriter), r);
    }

    public <E extends Exception> void addAdvice(Class<E> cls, ExceptionAdviceHandler<E, R> handler, R r) {
        this.adviceMap.put(cls, new ExceptionAdviceRegistry<E, R>(cls, handler, r));
    }

    public <E extends Exception> void deleteAdvice(Class<E> cls) {
        this.adviceMap.remove(cls);
    }

    public <E extends Exception> ExceptionAdviceRegistry<E, R> findRegistry(Class<? extends Exception> exceptionClass) {
        for (Class<? extends Exception> current = exceptionClass; current != null && Exception.class.isAssignableFrom(current); current = current.getSuperclass()) {
            ExceptionAdviceRegistry<? extends Exception, ? extends ErrorReasonDTO> registry = this.adviceMap.get(current);
            if (registry == null) continue;
            return registry;
        }
        return null;
    }

    public ExceptionAdviceConfigurer(FailureResponseWriter<R> failureResponseWriter) {
        this.failureResponseWriter = failureResponseWriter;
    }
}

