/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.namul.api.payload.code.dto.ErrorReasonDTO;
import org.namul.api.payload.handler.AbstractExceptionAdviceHandler;
import org.namul.api.payload.writer.FailureResponseWriter;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class MethodArgumentNotValidExceptionHandler<R extends ErrorReasonDTO>
extends AbstractExceptionAdviceHandler<MethodArgumentNotValidException, R> {
    public MethodArgumentNotValidExceptionHandler(FailureResponseWriter<R> failureResponseWriter) {
        super(failureResponseWriter);
    }

    @Override
    public Object getMessage(HttpServletRequest request, MethodArgumentNotValidException e, R errorReasonDTO) {
        LinkedHashMap errors = new LinkedHashMap();
        e.getBindingResult().getFieldErrors().forEach(fieldError -> {
            String fieldName = fieldError.getField();
            String errorMessage = Optional.ofNullable(fieldError.getDefaultMessage()).orElse("");
            errors.merge(fieldName, errorMessage, (existingErrorMessage, newErrorMessage) -> existingErrorMessage + ", " + newErrorMessage);
        });
        return errors;
    }
}

