/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message;

import java.util.ArrayList;
import java.util.List;
import org.namul.api.payload.message.ExceptionAdviceMessage;

public class DiscordExceptionAdviceMessage
implements ExceptionAdviceMessage {
    private String content;
    private List<Embed> embeds;

    public static DiscordExceptionAdviceMessage from(String content, String title1, String description1, String title2, String description2) {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        embeds.add(Embed.from(title1, description1));
        embeds.add(Embed.from(title2, description2));
        return DiscordExceptionAdviceMessage.from(content, embeds);
    }

    public static DiscordExceptionAdviceMessage from(String content, List<Embed> embeds) {
        return DiscordExceptionAdviceMessage.builder().content(content).embeds(embeds).build();
    }

    DiscordExceptionAdviceMessage(String content, List<Embed> embeds) {
        this.content = content;
        this.embeds = embeds;
    }

    public static DiscordExceptionAdviceMessageBuilder builder() {
        return new DiscordExceptionAdviceMessageBuilder();
    }

    public String getContent() {
        return this.content;
    }

    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    public static class Embed {
        private String title;
        private String description;

        public static Embed from(String title, String description) {
            return Embed.builder().title(title).description(description).build();
        }

        Embed(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public static EmbedBuilder builder() {
            return new EmbedBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public static class EmbedBuilder {
            private String title;
            private String description;

            EmbedBuilder() {
            }

            public EmbedBuilder title(String title) {
                this.title = title;
                return this;
            }

            public EmbedBuilder description(String description) {
                this.description = description;
                return this;
            }

            public Embed build() {
                return new Embed(this.title, this.description);
            }

            public String toString() {
                return "DiscordExceptionAdviceMessage.Embed.EmbedBuilder(title=" + this.title + ", description=" + this.description + ")";
            }
        }
    }

    public static class DiscordExceptionAdviceMessageBuilder {
        private String content;
        private List<Embed> embeds;

        DiscordExceptionAdviceMessageBuilder() {
        }

        public DiscordExceptionAdviceMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public DiscordExceptionAdviceMessageBuilder embeds(List<Embed> embeds) {
            this.embeds = embeds;
            return this;
        }

        public DiscordExceptionAdviceMessage build() {
            return new DiscordExceptionAdviceMessage(this.content, this.embeds);
        }

        public String toString() {
            return "DiscordExceptionAdviceMessage.DiscordExceptionAdviceMessageBuilder(content=" + this.content + ", embeds=" + this.embeds + ")";
        }
    }
}

