/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.namul.api.payload.message.DiscordExceptionAdviceMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DiscordExceptionAdviceUtil {
    private static final Logger log = LoggerFactory.getLogger(DiscordExceptionAdviceUtil.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void sendAlarm(String webHookUrl, DiscordExceptionAdviceMessage discordMessage) {
        if (webHookUrl == null || webHookUrl.isEmpty() || discordMessage == null) {
            log.warn("DiscordExceptionAdviceUtil: Cannot find Web hook url or discord message");
            return;
        }
        try {
            String jsonMessage = this.objectMapper.writeValueAsString((Object)discordMessage);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity request = new HttpEntity((Object)jsonMessage, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(webHookUrl, HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.NO_CONTENT) {
                log.warn("Failed to send Discord message: {}", (Object)response.getStatusCode());
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.warn("Failed to send Discord message", (Throwable)e);
        }
    }
}

