/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.namul.api.payload.message.SlackExceptionAdviceMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SlackExceptionAdviceUtil {
    private static final Logger log = LoggerFactory.getLogger(SlackExceptionAdviceUtil.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void sendAlarm(String webHookUrl, SlackExceptionAdviceMessage slackExceptionAdviceMessage) {
        if (webHookUrl == null || webHookUrl.isEmpty() || slackExceptionAdviceMessage == null) {
            log.warn("SlackExceptionAdviceUtil: Cannot find Web hook url or slack message");
            return;
        }
        try {
            String jsonMessage = this.objectMapper.writeValueAsString((Object)slackExceptionAdviceMessage);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-type", "application/json");
            HttpEntity request = new HttpEntity((Object)jsonMessage, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(webHookUrl, HttpMethod.POST, request, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                log.warn("Failed to send Slack message: {}", (Object)response.getStatusCode());
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.warn("Failed to send Slack message", (Throwable)e);
        }
    }
}

