/*
 * Decompiled with CFR 0.152.
 */
package org.namul.api.payload.message.generator;

import jakarta.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.namul.api.payload.message.SlackExceptionAdviceMessage;
import org.namul.api.payload.message.format.SlackDivider;
import org.namul.api.payload.message.format.SlackField;
import org.namul.api.payload.message.format.SlackHeader;
import org.namul.api.payload.message.format.SlackSection;
import org.namul.api.payload.message.generator.ExceptionAdviceMessageGenerator;

public class DefaultSlackExceptionAdviceMessageGenerator
implements ExceptionAdviceMessageGenerator<SlackExceptionAdviceMessage> {
    private static final String SLACK_HEADER = "\ud83d\udea8 Error";
    private static final String SLACK_SUB_HEADER = "*\u2139\ufe0f Error Info*";
    private static final String SLACK_TIME_INFO = "*\ud83d\udd56 Time:*\n%s\n";
    private static final String SLACK_REQUEST_INFO = "*\ud83d\udd17 Request URL:*\n%s\n";
    private static final String SLACK_MESSAGE_INFO = "*\ud83d\udcdd Message:*\n```\n%s\n```";
    private static final String SLACK_STACK_TRACE_TITLE = "*\ud83d\udcda Stack Trace*";
    private static final String SLACK_STACK_TRACE_DESCRIPTION_FORMAT = "```\n%s\n```";

    @Override
    public SlackExceptionAdviceMessage createMessage(HttpServletRequest request, Exception exception) {
        SlackExceptionAdviceMessage message = new SlackExceptionAdviceMessage();
        message.addBlock(SlackHeader.plainText(SLACK_HEADER));
        message.addBlock(SlackSection.Text.mrkdwn(SLACK_SUB_HEADER));
        ArrayList<SlackField> timeAndRequest = new ArrayList<SlackField>();
        timeAndRequest.add(SlackField.mrkdwn(String.format(SLACK_TIME_INFO, LocalDateTime.now())));
        timeAndRequest.add(SlackField.mrkdwn(String.format(SLACK_REQUEST_INFO, this.createRequestFullPath(request))));
        message.addBlock(SlackSection.Fields.builder().fields(timeAndRequest).build());
        message.addBlock(SlackSection.Text.mrkdwn(String.format(SLACK_MESSAGE_INFO, this.getErrorMethodAndClass(exception))));
        message.addBlock(SlackDivider.getInstance());
        message.addBlock(SlackSection.Text.mrkdwn(SLACK_STACK_TRACE_TITLE));
        message.addBlock(SlackSection.Text.mrkdwn(String.format(SLACK_STACK_TRACE_DESCRIPTION_FORMAT, this.getStackTrace(exception).substring(0, 1000))));
        return message;
    }

    private String createRequestFullPath(HttpServletRequest request) {
        String fullPath = request.getMethod() + " " + request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            fullPath = fullPath + "?" + queryString;
        }
        return fullPath;
    }

    private String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String getErrorMethodAndClass(Exception e) {
        StackTraceElement[] stackTraces = e.getStackTrace();
        if (stackTraces.length > 0) {
            StackTraceElement stackTrace = stackTraces[0];
            return "Method: " + stackTrace.getMethodName() + "\nClass: " + stackTrace.getClassName();
        }
        return null;
    }
}

