/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.io;

import org.canova.api.io.WritableComparator;

public abstract class BinaryComparable
implements Comparable<BinaryComparable> {
    public abstract int getLength();

    public abstract byte[] getBytes();

    @Override
    public int compareTo(BinaryComparable other) {
        if (this == other) {
            return 0;
        }
        return WritableComparator.compareBytes(this.getBytes(), 0, this.getLength(), other.getBytes(), 0, other.getLength());
    }

    public int compareTo(byte[] other, int off, int len) {
        return WritableComparator.compareBytes(this.getBytes(), 0, this.getLength(), other, off, len);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinaryComparable)) {
            return false;
        }
        BinaryComparable that = (BinaryComparable)other;
        if (this.getLength() != that.getLength()) {
            return false;
        }
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.getBytes(), this.getLength());
    }
}

