/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.records.reader.impl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.canova.api.io.data.Text;
import org.canova.api.records.reader.SequenceRecordReader;
import org.canova.api.records.reader.impl.FileRecordReader;
import org.canova.api.writable.Writable;

public class CSVSequenceRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    private int skipNumLines = 0;
    private String delimiter = ",";

    public CSVSequenceRecordReader() {
        this(0, ",");
    }

    public CSVSequenceRecordReader(int skipNumLines) {
        this(skipNumLines, ",");
    }

    public CSVSequenceRecordReader(int skipNumLines, String delimiter) {
        this.skipNumLines = skipNumLines;
        this.delimiter = delimiter;
    }

    @Override
    public Collection<Collection<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        this.invokeListeners(uri);
        LineIterator lineIter = IOUtils.lineIterator((Reader)new InputStreamReader(dataInputStream));
        if (this.skipNumLines > 0) {
            int count = 0;
            while (count++ < this.skipNumLines && lineIter.hasNext()) {
                lineIter.next();
            }
        }
        ArrayList<Collection<Writable>> out = new ArrayList<Collection<Writable>>();
        while (lineIter.hasNext()) {
            String line = (String)lineIter.next();
            String[] split = line.split(this.delimiter);
            ArrayList<Text> list = new ArrayList<Text>();
            for (String s : split) {
                list.add(new Text(s));
            }
            out.add(list);
        }
        return out;
    }

    @Override
    public Collection<Collection<Writable>> sequenceRecord() {
        LineIterator lineIter;
        File next = (File)this.iter.next();
        this.invokeListeners(next);
        try {
            lineIter = IOUtils.lineIterator((Reader)new InputStreamReader(new FileInputStream(next)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.skipNumLines > 0) {
            int count = 0;
            while (count++ < this.skipNumLines && lineIter.hasNext()) {
                lineIter.next();
            }
        }
        ArrayList<Collection<Writable>> out = new ArrayList<Collection<Writable>>();
        while (lineIter.hasNext()) {
            String line = (String)lineIter.next();
            String[] split = line.split(this.delimiter);
            ArrayList<Text> list = new ArrayList<Text>();
            for (String s : split) {
                list.add(new Text(s));
            }
            out.add(list);
        }
        return out;
    }
}

