/*
 * Decompiled with CFR 0.152.
 */
package org.canova.api.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.canova.api.split.BaseInputSplit;

public class FileSplit
extends BaseInputSplit {
    protected File rootDir;
    protected String[] allowFormat = null;
    protected boolean recursive = true;
    protected Random random;
    protected boolean randomize = false;

    protected FileSplit(File rootDir, String[] allowFormat, boolean recursive, Random random, boolean runMain) {
        this.allowFormat = allowFormat;
        this.recursive = recursive;
        this.rootDir = rootDir;
        if (random != null) {
            this.random = random;
            this.randomize = true;
        }
        if (runMain) {
            this.initialize();
        }
    }

    public FileSplit(File rootDir) {
        this(rootDir, null, true, null, true);
    }

    public FileSplit(File rootDir, Random rng) {
        this(rootDir, null, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat) {
        this(rootDir, allowFormat, true, null, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, Random rng) {
        this(rootDir, allowFormat, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, boolean recursive) {
        this(rootDir, allowFormat, recursive, null, true);
    }

    protected void initialize() {
        if (this.rootDir == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (this.rootDir.isDirectory()) {
            Collection subFiles = FileUtils.listFiles((File)this.rootDir, (String[])this.allowFormat, (boolean)this.recursive);
            this.locations = new URI[subFiles.size()];
            if (this.randomize) {
                Collections.shuffle((List)subFiles, this.random);
            }
            int count = 0;
            for (File f : subFiles) {
                this.locations[count++] = f.getPath().startsWith("file:") ? URI.create(f.getPath()) : f.toURI();
                this.length += f.length();
            }
        } else {
            String path = this.rootDir.getPath();
            this.locations = new URI[1];
            this.locations[0] = path.startsWith("file:") ? URI.create(path) : this.rootDir.toURI();
            this.length += this.rootDir.length();
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

