/*
 * Decompiled with CFR 0.152.
 */
package org.canova.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.canova.image.data.ImageWritable;
import org.canova.image.transform.BaseImageTransform;

public class ScaleImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    float dx;
    float dy;

    public ScaleImageTransform(float delta) {
        this(null, delta, delta);
    }

    public ScaleImageTransform(Random random, float delta) {
        this(random, delta, delta);
    }

    public ScaleImageTransform(float dx, float dy) {
        this(null, dx, dy);
    }

    public ScaleImageTransform(Random random, float dx, float dy) {
        super(random);
        this.dx = dx;
        this.dy = dy;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        int h = Math.round((float)mat.rows() + this.dy * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        int w = Math.round((float)mat.cols() + this.dx * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        opencv_core.Mat result = new opencv_core.Mat();
        opencv_imgproc.resize((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Size)new opencv_core.Size(w, h));
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

