/*
 * Decompiled with CFR 0.152.
 */
package org.canova.spark.functions.pairdata;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.function.Function;
import org.canova.api.records.reader.SequenceRecordReader;
import org.canova.api.writable.Writable;
import org.canova.spark.functions.pairdata.BytesPairWritable;
import scala.Tuple2;

public class PairSequenceRecordReaderBytesFunction
implements Function<Tuple2<Text, BytesPairWritable>, Tuple2<Collection<Collection<Writable>>, Collection<Collection<Writable>>>> {
    private final SequenceRecordReader recordReaderFirst;
    private final SequenceRecordReader recordReaderSecond;

    public PairSequenceRecordReaderBytesFunction(SequenceRecordReader recordReaderFirst, SequenceRecordReader recordReaderSecond) {
        this.recordReaderFirst = recordReaderFirst;
        this.recordReaderSecond = recordReaderSecond;
    }

    public Tuple2<Collection<Collection<Writable>>, Collection<Collection<Writable>>> call(Tuple2<Text, BytesPairWritable> v1) throws Exception {
        BytesPairWritable bpw = (BytesPairWritable)v1._2();
        DataInputStream dis1 = new DataInputStream(new ByteArrayInputStream(bpw.getFirst()));
        DataInputStream dis2 = new DataInputStream(new ByteArrayInputStream(bpw.getSecond()));
        URI u1 = bpw.getUriFirst() != null ? new URI(bpw.getUriFirst()) : null;
        URI u2 = bpw.getUriSecond() != null ? new URI(bpw.getUriSecond()) : null;
        Collection first = this.recordReaderFirst.sequenceRecord(u1, dis1);
        Collection second = this.recordReaderSecond.sequenceRecord(u2, dis2);
        return new Tuple2((Object)first, (Object)second);
    }
}

