/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.dataformat.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.DumperOptions;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.LoaderOptions;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.TypeDescription;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.Yaml;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.constructor.Constructor;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.introspector.BeanAccess;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.reader.UnicodeReader;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.representer.Representer;
import org.nd4j.shade.jackson.dataformat.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanLoader<T> {
    private Yaml loader;

    public JavaBeanLoader(TypeDescription typeDescription) {
        this(typeDescription, BeanAccess.DEFAULT);
    }

    public JavaBeanLoader(TypeDescription typeDescription, BeanAccess beanAccess) {
        this(new LoaderOptions(typeDescription), beanAccess);
    }

    public JavaBeanLoader(LoaderOptions options, BeanAccess beanAccess) {
        if (options == null) {
            throw new NullPointerException("LoaderOptions must be provided.");
        }
        if (options.getRootTypeDescription() == null) {
            throw new NullPointerException("TypeDescription must be provided.");
        }
        Constructor constructor = new Constructor(options.getRootTypeDescription());
        this.loader = new Yaml(constructor, options, new Representer(), new DumperOptions(), new Resolver());
        this.loader.setBeanAccess(beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz, BeanAccess beanAccess) {
        this(new TypeDescription(clazz), beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz) {
        this(clazz, BeanAccess.DEFAULT);
    }

    public T load(String yaml) {
        return (T)this.loader.load(new StringReader(yaml));
    }

    public T load(InputStream io) {
        return (T)this.loader.load(new UnicodeReader(io));
    }

    public T load(Reader io) {
        return (T)this.loader.load(io);
    }
}

