/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.cfg;

import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaFormatBase;

public class JacksonJodaDateFormat
extends JacksonJodaFormatBase {
    private static final String JODA_STYLE_CHARS = "SMLF-";
    protected final DateTimeFormatter _formatter;
    protected final TimeZone _jdkTimezone;
    protected final boolean _explicitTimezone;

    public JacksonJodaDateFormat(DateTimeFormatter defaultFormatter) {
        this._formatter = defaultFormatter;
        this._jdkTimezone = defaultFormatter.getZone().toTimeZone();
        this._explicitTimezone = false;
    }

    public JacksonJodaDateFormat(JacksonJodaDateFormat base, Boolean useTimestamp) {
        super((JacksonJodaFormatBase)base, useTimestamp);
        this._formatter = base._formatter;
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
    }

    public JacksonJodaDateFormat(JacksonJodaDateFormat base, DateTimeFormatter formatter) {
        super(base);
        this._formatter = formatter;
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
    }

    public JacksonJodaDateFormat(JacksonJodaDateFormat base, TimeZone jdkTimezone) {
        super((JacksonJodaFormatBase)base, jdkTimezone);
        this._formatter = base._formatter.withZone(DateTimeZone.forTimeZone((TimeZone)jdkTimezone));
        this._jdkTimezone = jdkTimezone;
        this._explicitTimezone = true;
    }

    public JacksonJodaDateFormat(JacksonJodaDateFormat base, Locale locale) {
        super((JacksonJodaFormatBase)base, locale);
        this._formatter = base._formatter.withLocale(locale);
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
    }

    public JacksonJodaDateFormat withUseTimestamp(Boolean useTimestamp) {
        if (this._useTimestamp != null && this._useTimestamp.equals(useTimestamp)) {
            return this;
        }
        return new JacksonJodaDateFormat(this, useTimestamp);
    }

    public JacksonJodaDateFormat withFormat(String format) {
        if (format == null || format.isEmpty()) {
            return this;
        }
        DateTimeFormatter formatter = JacksonJodaDateFormat._isStyle(format) ? DateTimeFormat.forStyle((String)format) : DateTimeFormat.forPattern((String)format);
        if (this._locale != null) {
            formatter = formatter.withLocale(this._locale);
        }
        formatter = formatter.withZone(this._formatter.getZone());
        return new JacksonJodaDateFormat(this, formatter);
    }

    public JacksonJodaDateFormat withTimeZone(TimeZone tz) {
        if (tz == null || this._jdkTimezone != null && this._jdkTimezone.equals(tz)) {
            return this;
        }
        return new JacksonJodaDateFormat(this, tz);
    }

    public JacksonJodaDateFormat withLocale(Locale locale) {
        if (locale == null || this._locale != null && this._locale.equals(locale)) {
            return this;
        }
        return new JacksonJodaDateFormat(this, locale);
    }

    public DateTimeFormatter createFormatter(SerializerProvider provider) {
        TimeZone tz;
        Locale loc;
        DateTimeFormatter formatter = this._formatter;
        if (!this._explicitLocale && (loc = provider.getLocale()) != null && !loc.equals(this._locale)) {
            formatter = formatter.withLocale(loc);
        }
        if (!this._explicitTimezone && (tz = provider.getTimeZone()) != null && !tz.equals(this._jdkTimezone)) {
            formatter = formatter.withZone(DateTimeZone.forTimeZone((TimeZone)tz));
        }
        return formatter;
    }

    protected static boolean _isStyle(String formatStr) {
        if (formatStr.length() != 2) {
            return false;
        }
        return JODA_STYLE_CHARS.indexOf(formatStr.charAt(0)) >= 0 && JODA_STYLE_CHARS.indexOf(formatStr.charAt(0)) >= 0;
    }
}

