/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_VARIABLE_ND4J_GRAPH_H_
#define FLATBUFFERS_GENERATED_VARIABLE_ND4J_GRAPH_H_

#include "flatbuffers/flatbuffers.h"

#include "array_generated.h"
#include "utils_generated.h"

namespace nd4j {
namespace graph {

struct FlatVariable;

struct FlatVariable FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum {
    VT_ID = 4,
    VT_NAME = 6,
    VT_SHAPE = 8,
    VT_NDARRAY = 10,
    VT_DEVICE = 12
  };
  const IntPair *id() const {
    return GetPointer<const IntPair *>(VT_ID);
  }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::Vector<int64_t> *shape() const {
    return GetPointer<const flatbuffers::Vector<int64_t> *>(VT_SHAPE);
  }
  const FlatArray *ndarray() const {
    return GetPointer<const FlatArray *>(VT_NDARRAY);
  }
  int32_t device() const {
    return GetField<int32_t>(VT_DEVICE, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_ID) &&
           verifier.VerifyTable(id()) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.Verify(name()) &&
           VerifyOffset(verifier, VT_SHAPE) &&
           verifier.Verify(shape()) &&
           VerifyOffset(verifier, VT_NDARRAY) &&
           verifier.VerifyTable(ndarray()) &&
           VerifyField<int32_t>(verifier, VT_DEVICE) &&
           verifier.EndTable();
  }
};

struct FlatVariableBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_id(flatbuffers::Offset<IntPair> id) {
    fbb_.AddOffset(FlatVariable::VT_ID, id);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(FlatVariable::VT_NAME, name);
  }
  void add_shape(flatbuffers::Offset<flatbuffers::Vector<int64_t>> shape) {
    fbb_.AddOffset(FlatVariable::VT_SHAPE, shape);
  }
  void add_ndarray(flatbuffers::Offset<FlatArray> ndarray) {
    fbb_.AddOffset(FlatVariable::VT_NDARRAY, ndarray);
  }
  void add_device(int32_t device) {
    fbb_.AddElement<int32_t>(FlatVariable::VT_DEVICE, device, 0);
  }
  explicit FlatVariableBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  FlatVariableBuilder &operator=(const FlatVariableBuilder &);
  flatbuffers::Offset<FlatVariable> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FlatVariable>(end);
    return o;
  }
};

inline flatbuffers::Offset<FlatVariable> CreateFlatVariable(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<IntPair> id = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::Vector<int64_t>> shape = 0,
    flatbuffers::Offset<FlatArray> ndarray = 0,
    int32_t device = 0) {
  FlatVariableBuilder builder_(_fbb);
  builder_.add_device(device);
  builder_.add_ndarray(ndarray);
  builder_.add_shape(shape);
  builder_.add_name(name);
  builder_.add_id(id);
  return builder_.Finish();
}

inline flatbuffers::Offset<FlatVariable> CreateFlatVariableDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<IntPair> id = 0,
    const char *name = nullptr,
    const std::vector<int64_t> *shape = nullptr,
    flatbuffers::Offset<FlatArray> ndarray = 0,
    int32_t device = 0) {
  return nd4j::graph::CreateFlatVariable(
      _fbb,
      id,
      name ? _fbb.CreateString(name) : 0,
      shape ? _fbb.CreateVector<int64_t>(*shape) : 0,
      ndarray,
      device);
}

inline const nd4j::graph::FlatVariable *GetFlatVariable(const void *buf) {
  return flatbuffers::GetRoot<nd4j::graph::FlatVariable>(buf);
}

inline bool VerifyFlatVariableBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<nd4j::graph::FlatVariable>(nullptr);
}

inline void FinishFlatVariableBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<nd4j::graph::FlatVariable> root) {
  fbb.Finish(root);
}

}  // namespace graph
}  // namespace nd4j

#endif  // FLATBUFFERS_GENERATED_VARIABLE_ND4J_GRAPH_H_
