/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 10.02.18.
//

#include <op_boilerplate.h>
#if NOT_EXCLUDED(OP_tf_atan2)

#include <ops/declarable/headers/parity_ops.h>

namespace nd4j {
    namespace ops {

        OP_IMPL(tf_atan2, 2, 1, true) {
            auto y = INPUT_VARIABLE(0);
            auto x = INPUT_VARIABLE(1);
            auto z = OUTPUT_VARIABLE(0);

            x->template applyPairwiseTransform<simdOps::Atan2<T>>(y, z, nullptr);

            return Status::OK();
        }
    }
}

#endif