/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver on 4/5/2018.
//

#ifndef LIBND4J_TRIPLE_H
#define LIBND4J_TRIPLE_H


#include <dll.h>

namespace nd4j {
    class ND4J_EXPORT Triple {
    protected:
        int _first = 0;
        int _second = 0;
        int _third = 0;

    public:
        Triple(int first = 0, int second = 0, int third = 0);
        ~Triple() = default;

        int first() const;
        int second() const;
        int third() const;
    };
}

#endif //LIBND4J_TRIPLE_H
